/*
 * Decompiled with CFR 0.152.
 */
package com.github.burgerguy.hudtweaks.hud.element;

import com.github.burgerguy.hudtweaks.hud.XAxisNode;
import com.github.burgerguy.hudtweaks.hud.YAxisNode;
import com.github.burgerguy.hudtweaks.hud.element.HudElement;
import com.github.burgerguy.hudtweaks.util.gl.DashedBoxOutline;
import com.github.burgerguy.hudtweaks.util.gl.GLUtil;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

public class HudElementWidget
implements class_4068,
class_364,
AutoCloseable,
Comparable<HudElementWidget> {
    private static final int OUTLINE_COLOR_NORMAL = -65536;
    private static final int OUTLINE_COLOR_SELECTED = -16776961;
    private static final float TICKS_PER_SHIFT = 5.0f;
    private static final byte PATTERN_LENGTH = 4;
    private final HudElement element;
    private final Runnable valueUpdater;
    private final DashedBoxOutline dashedBoxOutline = new DashedBoxOutline();
    private int dashPattern = 12;
    private float tickCounter;
    private boolean focused;
    private boolean lastChildFocused;
    private boolean lastElementRendered;

    protected HudElementWidget(HudElement element, @Nullable Runnable valueUpdater) {
        this.element = element;
        this.valueUpdater = valueUpdater;
    }

    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float delta) {
        class_310 client = class_310.method_1551();
        boolean draw = false;
        boolean dashed = false;
        this.lastElementRendered = this.element.isRendered();
        if (this.lastElementRendered) {
            draw = true;
        } else if (this.focused || (this.lastChildFocused = this.isChildFocused())) {
            draw = true;
            dashed = true;
        }
        if (draw) {
            int color;
            double x1 = this.element.getX(client);
            double y1 = this.element.getY(client);
            double x2 = x1 + this.element.getWidth(client);
            double y2 = y1 + this.element.getHeight(client);
            int n = color = this.focused ? -16776961 : -65536;
            if (dashed) {
                if (this.focused) {
                    this.cyclePattern(delta, 5.0f);
                }
                this.dashedBoxOutline.draw(matrixStack, color, this.dashPattern, (byte)4, x1 - 0.5, y1 - 0.5, x2 + 0.5, y2 + 0.5, (float)client.method_22683().method_4495());
            } else {
                GLUtil.drawBoxOutline(matrixStack, x1 - 0.5, y1 - 0.5, x2 + 0.5, y2 + 0.5, color, (float)client.method_22683().method_4495());
            }
        }
    }

    private void cyclePattern(float delta, float ticksPerShift) {
        this.tickCounter += delta;
        if (this.tickCounter >= ticksPerShift) {
            this.tickCounter = 0.0f;
            this.dashPattern = 0xF & (this.dashPattern << 3 | this.dashPattern >>> 1);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_25405(mouseX, mouseY)) {
            this.focused = button == 0;
            return this.focused;
        }
        this.focused = false;
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (class_437.method_25442()) {
            class_310 client = class_310.method_1551();
            if (!this.element.xPosType.equals((Object)HudElement.PosType.DEFAULT)) {
                this.element.xRelativePos = class_3532.method_15350((double)(this.element.xRelativePos + deltaX / this.element.getXParent().getWidth(client)), (double)0.0, (double)1.0);
            }
            if (!this.element.yPosType.equals((Object)HudElement.PosType.DEFAULT)) {
                this.element.yRelativePos = class_3532.method_15350((double)(this.element.yRelativePos + deltaY / this.element.getYParent().getHeight(client)), (double)0.0, (double)1.0);
            }
        } else {
            this.element.xOffset += deltaX;
            this.element.yOffset += deltaY;
        }
        this.element.setRequiresUpdate();
        if (this.valueUpdater != null) {
            this.valueUpdater.run();
        }
        return true;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        class_310 client = class_310.method_1551();
        if (this.lastElementRendered || this.focused || this.lastChildFocused) {
            double x1 = this.element.getX(client);
            double y1 = this.element.getY(client);
            double x2 = x1 + this.element.getWidth(client);
            double y2 = y1 + this.element.getHeight(client);
            return mouseX >= x1 && mouseX <= x2 && mouseY >= y1 && mouseY <= y2;
        }
        return false;
    }

    public boolean method_25407(boolean lookForward) {
        this.focused = !this.focused;
        return this.focused;
    }

    private boolean isChildFocused() {
        HudElement element;
        for (XAxisNode xAxisNode : this.element.getXChildren()) {
            if (!(xAxisNode instanceof HudElement) || !(element = (HudElement)xAxisNode).getWidget().isFocused() || !element.getXPosType().equals((Object)HudElement.PosType.RELATIVE)) continue;
            return true;
        }
        for (YAxisNode yAxisNode : this.element.getYChildren()) {
            if (!(yAxisNode instanceof HudElement) || !(element = (HudElement)yAxisNode).getWidget().isFocused() || !element.getYPosType().equals((Object)HudElement.PosType.RELATIVE)) continue;
            return true;
        }
        return false;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public HudElement getElement() {
        return this.element;
    }

    @Override
    public int compareTo(HudElementWidget other) {
        class_310 client = class_310.method_1551();
        HudElement otherElement = other.getElement();
        return Double.compare(this.element.getWidth(client) * this.element.getHeight(client), otherElement.getWidth(client) * otherElement.getHeight(client));
    }

    @Override
    public void close() {
        this.dashedBoxOutline.close();
        this.element.widget = null;
    }
}

