/*
 * Decompiled with CFR 0.152.
 */
package com.github.burgerguy.hudtweaks.hud.element;

import com.github.burgerguy.hudtweaks.gui.widget.HTButtonWidget;
import com.github.burgerguy.hudtweaks.gui.widget.SidebarWidget;
import com.github.burgerguy.hudtweaks.hud.element.HudElement;
import com.google.gson.JsonElement;
import net.minecraft.class_1074;
import net.minecraft.class_1293;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_4068;

public class StatusEffectsElement
extends HudElement {
    private boolean vertical;

    public StatusEffectsElement() {
        super("statuseffects", "onStatusEffectsChange");
    }

    @Override
    protected double calculateWidth(class_310 client) {
        return this.vertical ? (double)this.getRawHeight(client) : (double)this.getRawWidth(client);
    }

    @Override
    protected double calculateHeight(class_310 client) {
        return this.vertical ? (double)this.getRawWidth(client) : (double)this.getRawHeight(client);
    }

    private int getRawWidth(class_310 client) {
        int beneficial = 0;
        int other = 0;
        for (class_1293 effect : client.field_1724.method_6026()) {
            if (effect.method_5579().method_5573()) {
                ++beneficial;
                continue;
            }
            ++other;
        }
        return Math.max(Math.max(beneficial, other), 1) * 25 - 1;
    }

    private int getRawHeight(class_310 client) {
        boolean hasBeneficial = false;
        boolean hasOther = false;
        for (class_1293 effect : client.field_1724.method_6026()) {
            if (effect.method_5579().method_5573()) {
                hasBeneficial = true;
            } else {
                hasOther = true;
            }
            if (!hasBeneficial || !hasOther) continue;
            return 50;
        }
        return 24;
    }

    private int getNonBeneficialOffset(class_310 client) {
        boolean hasBeneficial = false;
        boolean hasOther = false;
        for (class_1293 effect : client.field_1724.method_6026()) {
            if (effect.method_5579().method_5573()) {
                hasBeneficial = true;
            } else {
                hasOther = true;
            }
            if (hasBeneficial || !hasOther) continue;
            return 26;
        }
        return 0;
    }

    @Override
    protected double calculateDefaultX(class_310 client) {
        return (double)client.method_22683().method_4486() - this.calculateWidth(client) - 1.0 - (double)(this.vertical ? this.getNonBeneficialOffset(client) : 0);
    }

    @Override
    protected double calculateDefaultY(class_310 client) {
        return (client.method_1530() ? 16 : 1) + (this.vertical ? 0 : this.getNonBeneficialOffset(client));
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
    }

    @Override
    public void updateFromJson(JsonElement json) {
        super.updateFromJson(json);
        this.setVertical(json.getAsJsonObject().get("vertical").getAsBoolean());
    }

    @Override
    public void fillSidebar(SidebarWidget sidebar) {
        super.fillSidebar(sidebar);
        sidebar.addDrawable((class_4068)new HTButtonWidget(4, 276, sidebar.width - 8, 14, (class_2561)new class_2588("hudtweaks.options.statuseffects.style.display", new Object[]{this.vertical ? class_1074.method_4662((String)"hudtweaks.options.statuseffects.style.vertical.display", (Object[])new Object[0]) : class_1074.method_4662((String)"hudtweaks.options.statuseffects.style.horizontal.display", (Object[])new Object[0])})){

            public void method_25306() {
                StatusEffectsElement.this.vertical = !StatusEffectsElement.this.vertical;
                this.method_25355((class_2561)new class_2588("hudtweaks.options.statuseffects.style.display", new Object[]{StatusEffectsElement.this.vertical ? class_1074.method_4662((String)"hudtweaks.options.statuseffects.style.vertical.display", (Object[])new Object[0]) : class_1074.method_4662((String)"hudtweaks.options.statuseffects.style.horizontal.display", (Object[])new Object[0])}));
                StatusEffectsElement.this.setRequiresUpdate();
            }
        });
    }

    @Override
    public int getSidebarOptionsHeight() {
        return super.getSidebarOptionsHeight() + 25;
    }
}

