/*
 * Decompiled with CFR 0.152.
 */
package com.github.burgerguy.hudtweaks.mixin;

import com.github.burgerguy.hudtweaks.gui.HTOptionsScreen;
import com.github.burgerguy.hudtweaks.hud.HudContainer;
import com.github.burgerguy.hudtweaks.hud.UpdateEvent;
import com.github.burgerguy.hudtweaks.hud.XAxisNode;
import com.github.burgerguy.hudtweaks.hud.YAxisNode;
import com.github.burgerguy.hudtweaks.hud.element.ExperienceBarElement;
import com.github.burgerguy.hudtweaks.hud.element.HealthElement;
import com.github.burgerguy.hudtweaks.hud.element.HudElement;
import com.github.burgerguy.hudtweaks.hud.element.HungerElement;
import com.github.burgerguy.hudtweaks.hud.element.StatusEffectsElement;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_4074;
import net.minecraft.class_4587;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_329.class})
public abstract class InGameHudMixin
extends class_332 {
    @Final
    @Shadow
    private class_310 field_2035;
    @Unique
    private final Set<XAxisNode> updatedElementsX = new HashSet<XAxisNode>();
    @Unique
    private final Set<YAxisNode> updatedElementsY = new HashSet<YAxisNode>();
    @Unique
    private static final int STATUS_EFFECT_OFFSET = 25;
    @Unique
    private int preX;
    @Unique
    private int preY;
    @Unique
    private int postX;
    @Unique
    private int postY;

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void renderStart(class_4587 matrices, float tickDelta, CallbackInfo callbackInfo) {
        int scaledWidth = this.field_2035.method_22683().method_4486();
        int scaledHeight = this.field_2035.method_22683().method_4502();
        if (HTOptionsScreen.isOpen()) {
            super.method_25296(matrices, 0, 0, scaledWidth, scaledHeight, -1072689136, -804253680);
        }
        for (HudElement hudElement : HudContainer.getElements()) {
            hudElement.clearDrawTest();
        }
        this.field_2035.method_16011().method_15396("fireHudTweaksEvents");
        this.updatedElementsX.clear();
        this.updatedElementsY.clear();
        HudContainer.getScreenRoot().tryUpdateX(null, this.field_2035, false, this.updatedElementsX);
        HudContainer.getScreenRoot().tryUpdateY(null, this.field_2035, false, this.updatedElementsY);
        for (UpdateEvent updateEvent : HudContainer.getEventRegistry().getAllEvents()) {
            if (!updateEvent.shouldUpdate(this.field_2035)) continue;
            HudContainer.getScreenRoot().tryUpdateX(updateEvent, this.field_2035, false, this.updatedElementsX);
            HudContainer.getScreenRoot().tryUpdateY(updateEvent, this.field_2035, false, this.updatedElementsY);
        }
        for (Object object : Sets.union(this.updatedElementsX, this.updatedElementsY)) {
            if (!(object instanceof HudElement)) continue;
            HudElement hudElement = (HudElement)object;
            HudContainer.getMatrixCache().putMatrix(hudElement.getIdentifier(), hudElement.createMatrix(this.field_2035));
        }
        this.field_2035.method_16011().method_15407();
    }

    @Inject(method={"renderHotbar"}, at={@At(value="HEAD")})
    private void renderHotbarHead(float tickDelta, class_4587 matrices, CallbackInfo callbackInfo) {
        HudContainer.getMatrixCache().tryPushMatrix("hotbar", null);
    }

    @Inject(method={"renderHotbar"}, at={@At(value="RETURN")})
    private void renderHotbarReturn(float tickDelta, class_4587 matrices, CallbackInfo callbackInfo) {
        HudContainer.getMatrixCache().tryPopMatrix("hotbar", null);
    }

    @Inject(method={"renderStatusBars"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiler/Profiler;push(Ljava/lang/String;)V", args={"ldc=armor"})})
    private void renderArmor(class_4587 matrices, CallbackInfo callbackInfo) {
        HudContainer.getMatrixCache().tryPushMatrix("armor", matrices);
    }

    @Inject(method={"renderStatusBars"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiler/Profiler;swap(Ljava/lang/String;)V", args={"ldc=health"})})
    private void renderHealth(class_4587 matrices, CallbackInfo callbackInfo) {
        HudContainer.getMatrixCache().tryPopMatrix("armor", matrices);
        HudContainer.getMatrixCache().tryPushMatrix("health", matrices);
    }

    @ModifyVariable(method={"renderStatusBars"}, ordinal=19, at=@At(value="JUMP", opcode=163))
    private int flipHealthStackDirection(int healthPos) {
        if (((HealthElement)HudContainer.getElement("health")).isFlipped()) {
            int originalHealthPos = this.field_2035.method_22683().method_4502() - 39;
            return originalHealthPos + originalHealthPos - healthPos;
        }
        return healthPos;
    }

    @ModifyVariable(method={"renderStatusBars"}, ordinal=11, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/client/gui/hud/InGameHud;getHeartCount(Lnet/minecraft/entity/LivingEntity;)I"))
    private int forceRenderHunger(int mountHealth) {
        if (((HungerElement)HudContainer.getElement("hunger")).getForceDisplay()) {
            return 0;
        }
        return mountHealth;
    }

    @Inject(method={"renderStatusBars"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/client/gui/hud/InGameHud;getHeartCount(Lnet/minecraft/entity/LivingEntity;)I")})
    private void renderHunger(class_4587 matrices, CallbackInfo callbackInfo) {
        HudContainer.getMatrixCache().tryPopMatrix("health", matrices);
        HudContainer.getMatrixCache().tryPushMatrix("hunger", matrices);
    }

    @Inject(method={"renderStatusBars"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiler/Profiler;swap(Ljava/lang/String;)V", args={"ldc=air"})})
    private void renderAir(class_4587 matrices, CallbackInfo callbackInfo) {
        HudContainer.getMatrixCache().tryPopMatrix("hunger", matrices);
        HudContainer.getMatrixCache().tryPushMatrix("air", matrices);
    }

    @Inject(method={"renderStatusBars"}, at={@At(value="RETURN")})
    private void renderStatusBarsReturn(class_4587 matrices, CallbackInfo callbackInfo) {
        HudContainer.getMatrixCache().tryPopMatrix("air", matrices);
    }

    @Inject(method={"renderMountHealth"}, at={@At(value="HEAD")})
    private void renderMountHealthHead(class_4587 matrices, CallbackInfo callbackInfo) {
        HudContainer.getMatrixCache().tryPushMatrix("mounthealth", matrices);
    }

    @Inject(method={"renderMountHealth"}, at={@At(value="RETURN")})
    private void renderMountHealthReturn(class_4587 matrices, CallbackInfo callbackInfo) {
        HudContainer.getMatrixCache().tryPopMatrix("mounthealth", matrices);
    }

    @Inject(method={"renderExperienceBar"}, at={@At(value="HEAD")})
    public void renderExperienceBarHead(class_4587 matrices, int x, CallbackInfo callbackInfo) {
        HudContainer.getMatrixCache().tryPushMatrix("expbar", matrices);
    }

    @Inject(method={"renderExperienceBar"}, at={@At(value="RETURN")})
    public void renderExperienceBarReturn(class_4587 matrices, int x, CallbackInfo callbackInfo) {
        HudContainer.getMatrixCache().tryPopMatrix("expbar", matrices);
    }

    @Shadow
    public abstract void method_1754(class_4587 var1, int var2);

    @Inject(method={"renderMountJumpBar"}, at={@At(value="HEAD")})
    public void renderMountJumpBarHead(class_4587 matrices, int x, CallbackInfo callbackInfo) {
        if (((ExperienceBarElement)HudContainer.getElement("expbar")).getForceDisplay()) {
            this.method_1754(matrices, x);
        }
        HudContainer.getMatrixCache().tryPushMatrix("jumpbar", matrices);
    }

    @Inject(method={"renderMountJumpBar"}, at={@At(value="RETURN")})
    public void renderMountJumpBarReturn(class_4587 matrices, int x, CallbackInfo callbackInfo) {
        HudContainer.getMatrixCache().tryPopMatrix("jumpbar", matrices);
    }

    @Inject(method={"renderStatusEffectOverlay"}, at={@At(value="HEAD")})
    private void renderStatusEffectOverlayHead(class_4587 matrices, CallbackInfo callbackInfo) {
        HudContainer.getMatrixCache().tryPushMatrix("statuseffects", matrices);
    }

    @Inject(method={"renderStatusEffectOverlay"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/effect/StatusEffect;isBeneficial()Z")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void setupPreCalcVars(class_4587 matrices, CallbackInfo callbackInfo, Collection<?> u1, int u2, int u3, class_4074 u4, List<?> u5, Iterator<?> u6, class_1293 u7, class_1291 u8, int x, int y) {
        this.preX = x;
        this.preY = y;
    }

    @Inject(method={"renderStatusEffectOverlay"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/effect/StatusEffectInstance;isAmbient()Z")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void setupPostCalcVars(class_4587 matrices, CallbackInfo callbackInfo, Collection<?> u1, int u2, int u3, class_4074 u4, List<?> u5, Iterator<?> u6, class_1293 u7, class_1291 u8, int x, int y) {
        this.postX = x;
        this.postY = y;
    }

    @ModifyVariable(method={"renderStatusEffectOverlay"}, ordinal=2, at=@At(value="INVOKE", target="Lnet/minecraft/entity/effect/StatusEffectInstance;isAmbient()Z"))
    private int modifyStatusEffectX(int x, class_4587 maxtixStack) {
        if (((StatusEffectsElement)HudContainer.getElement("statuseffects")).isVertical()) {
            return this.field_2035.method_22683().method_4486() - 25 + this.preY - this.postY;
        }
        return x;
    }

    @ModifyVariable(method={"renderStatusEffectOverlay"}, ordinal=3, at=@At(value="INVOKE", target="Lnet/minecraft/entity/effect/StatusEffectInstance;isAmbient()Z"))
    private int modifyStatusEffectY(int y, class_4587 maxtixStack) {
        if (((StatusEffectsElement)HudContainer.getElement("statuseffects")).isVertical()) {
            return this.preY + this.field_2035.method_22683().method_4486() - this.postX - 25;
        }
        return y;
    }

    @Inject(method={"renderStatusEffectOverlay"}, at={@At(value="RETURN")})
    private void renderStatusEffectOverlayReturn(class_4587 matrices, CallbackInfo callbackInfo) {
        HudContainer.getMatrixCache().tryPopMatrix("statuseffects", matrices);
    }
}

