/*
 * Decompiled with CFR 0.152.
 */
package com.github.burgerguy.hudtweaks.util;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;

public class UnmodifiableMergedList<T>
extends AbstractList<T> {
    private final List<T>[] lists;
    private final int size;

    @SafeVarargs
    public UnmodifiableMergedList(List<T> ... lists) {
        this.lists = (List[])lists.clone();
        this.size = Arrays.stream(lists).mapToInt(List::size).sum();
    }

    @Override
    public T get(int index) {
        for (List<T> list : this.lists) {
            if (index < list.size()) {
                return list.get(index);
            }
            index -= list.size();
        }
        throw new IndexOutOfBoundsException("index");
    }

    @Override
    public int size() {
        return this.size;
    }
}

