/*
 * Decompiled with CFR 0.152.
 */
package com.github.burgerguy.hudtweaks.util;

import com.github.burgerguy.hudtweaks.hud.element.HudElement;
import com.github.burgerguy.hudtweaks.util.json.HudElementSerializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum Util {

    public static final Gson GSON;
    public static final JsonParser JSON_PARSER;
    public static final Logger LOGGER;
    public static final NumberFormat RELATIVE_POS_FORMATTER;
    public static final NumberFormat ANCHOR_POS_FORMATTER;
    public static final NumberFormat NUM_FIELD_FORMATTER;
    public static boolean SHOULD_COMPENSATE_FOR_MODMENU_BUTTON;

    public static <T> boolean containsNotNull(Set<T> set, T item) {
        if (item == null) {
            return false;
        }
        return set.contains(item);
    }

    public static double minClamp(double value, double min, double max) {
        if (value < min || max <= min) {
            return min;
        }
        return value > max ? max : value;
    }

    static {
        JSON_PARSER = new JsonParser();
        LOGGER = LogManager.getLogger((String)"HUDTweaks");
        RELATIVE_POS_FORMATTER = new DecimalFormat("%##0.0");
        ANCHOR_POS_FORMATTER = new DecimalFormat("%##0.0");
        NUM_FIELD_FORMATTER = new DecimalFormat("####0.0");
        SHOULD_COMPENSATE_FOR_MODMENU_BUTTON = false;
        GSON = new GsonBuilder().setPrettyPrinting().registerTypeHierarchyAdapter(HudElement.class, (Object)new HudElementSerializer()).create();
    }
}

