/*
 * Decompiled with CFR 0.152.
 */
package com.github.burgerguy.hudtweaks.util.gl;

import com.github.burgerguy.hudtweaks.util.gl.HTVertexConsumerProvider;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1159;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;

public class DashedBoxOutline
implements AutoCloseable {
    private static final String TEXTURE_NAME_PREFIX = "dashed-line-tex";
    private class_1043 texture;
    private class_2960 texId;
    private int pattern;
    private byte patternLength;

    public void draw(class_4587 matrices, int color, int pattern, byte patternLength, double x1, double y1, double x2, double y2, float width) {
        boolean newTex = false;
        if (this.patternLength != patternLength) {
            this.patternLength = patternLength;
            if (this.texture != null) {
                this.texture.close();
            }
            this.texture = new class_1043(patternLength, 1, false);
            this.texId = class_310.method_1551().method_1531().method_4617(TEXTURE_NAME_PREFIX, this.texture);
            newTex = true;
        }
        if (this.pattern != pattern || newTex) {
            this.pattern = pattern;
            class_1011 image = this.texture.method_4525();
            for (int i = 0; i < patternLength; ++i) {
                if ((pattern >> i & 1) == 1) {
                    image.method_4305(i, 0, -1);
                    continue;
                }
                image.method_4305(i, 0, 0);
            }
            this.texture.method_4524();
        }
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        class_1159 matrix = matrices.method_23760().method_23761();
        class_4588 consumer = HTVertexConsumerProvider.getDashedOutlineConsumer(this.texId, width);
        consumer.method_22918(matrix, (float)x1, (float)y2, 0.0f).method_1336(r, g, b, a).method_22913(0.0f, 1.0f).method_1344();
        double wrapTexPos = this.calcTexLength(x1, y2, x2, y2);
        consumer.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_1336(r, g, b, a).method_22913((float)wrapTexPos, 1.0f).method_1344();
        consumer.method_22918(matrix, (float)x2, (float)y1, 0.0f).method_1336(r, g, b, a).method_22913((float)(wrapTexPos += this.calcTexLength(x2, y2, x2, y1)), 1.0f).method_1344();
        consumer.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_1336(r, g, b, a).method_22913((float)(wrapTexPos += this.calcTexLength(x2, y1, x1, y1)), 1.0f).method_1344();
        consumer.method_22918(matrix, (float)x1, (float)y2, 0.0f).method_1336(r, g, b, a).method_22913((float)(wrapTexPos += this.calcTexLength(x1, y1, x1, y2)), 1.0f).method_1344();
        HTVertexConsumerProvider.draw();
    }

    private double calcTexLength(double lastX, double lastY, double thisX, double thisY) {
        return Math.sqrt(Math.pow(thisX - lastX, 2.0) + Math.pow(thisY - lastY, 2.0)) / (double)this.patternLength;
    }

    @Override
    public void close() {
        if (this.texture != null) {
            this.texture.close();
        }
    }
}

