/*
 * Decompiled with CFR 0.152.
 */
package com.github.burgerguy.hudtweaks.util.gl;

import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL15;
import org.lwjgl.system.MemoryUtil;

public class DrawTest
implements AutoCloseable {
    private static final int QUERY_TARGET = DrawTest.getQueryTarget();
    private final int queryId = GL15.glGenQueries();
    private boolean active;
    private final long pointer = MemoryUtil.nmemAlloc((long)5L);

    public boolean start() {
        if (!this.active) {
            this.active = true;
            GL15.glBeginQuery((int)QUERY_TARGET, (int)this.queryId);
            return true;
        }
        return false;
    }

    public boolean end() {
        if (this.active) {
            GL15.glEndQuery((int)QUERY_TARGET);
            this.active = false;
            return true;
        }
        return false;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean getAvailability() {
        GL15.nglGetQueryObjectiv((int)this.queryId, (int)34919, (long)(this.pointer + 4L));
        return MemoryUtil.memGetBoolean((long)(this.pointer + 4L));
    }

    public boolean getResultSync() {
        GL15.nglGetQueryObjectiv((int)this.queryId, (int)34918, (long)this.pointer);
        return MemoryUtil.memGetInt((long)this.pointer) > 0;
    }

    public Boolean tryGetResultAsync() {
        if (this.getAvailability()) {
            return this.getResultSync();
        }
        return null;
    }

    private static int getQueryTarget() {
        int queryTarget = 35092;
        if (GL.getCapabilities().OpenGL33) {
            queryTarget = 35887;
            if (GL.getCapabilities().OpenGL43) {
                queryTarget = 36202;
            }
        }
        return queryTarget;
    }

    @Override
    public void close() {
        GL15.glDeleteQueries((int)this.queryId);
        MemoryUtil.nmemFree((long)this.pointer);
    }
}

