/*
 * Decompiled with CFR 0.152.
 */
package com.github.burgerguy.hudtweaks.util.json;

import com.github.burgerguy.hudtweaks.hud.element.HudElement;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class HudElementSerializer
implements JsonSerializer<HudElement> {
    private static final Gson DEFAULT_GSON = new GsonBuilder().setPrettyPrinting().create();

    public JsonElement serialize(HudElement element, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject xPosObject = new JsonObject();
        xPosObject.add("posType", context.serialize((Object)element.getXPosType()));
        xPosObject.add("parent", context.serialize((Object)element.getXParent().getIdentifier()));
        xPosObject.add("anchorPos", context.serialize((Object)element.getXAnchorPos()));
        xPosObject.add("relativePos", context.serialize((Object)element.getXRelativePos()));
        xPosObject.add("offset", context.serialize((Object)element.getXOffset()));
        JsonObject yPosObject = new JsonObject();
        yPosObject.add("posType", context.serialize((Object)element.getYPosType()));
        yPosObject.add("parent", context.serialize((Object)element.getYParent().getIdentifier()));
        yPosObject.add("anchorPos", context.serialize((Object)element.getYAnchorPos()));
        yPosObject.add("relativePos", context.serialize((Object)element.getYRelativePos()));
        yPosObject.add("offset", context.serialize((Object)element.getYOffset()));
        JsonObject baseObject = DEFAULT_GSON.toJsonTree((Object)element, TypeToken.of(Object.class).getType()).getAsJsonObject();
        baseObject.add("xPos", (JsonElement)xPosObject);
        baseObject.add("yPos", (JsonElement)yPosObject);
        baseObject.add("xScale", context.serialize((Object)element.getXScale()));
        baseObject.add("yScale", context.serialize((Object)element.getYScale()));
        return baseObject;
    }
}

