/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client;

import com.github.franckyi.ibeeditor.client.screen.model.selection.element.EnchantmentListSelectionElementModel;
import com.github.franckyi.ibeeditor.client.screen.model.selection.element.ItemListSelectionElementModel;
import com.github.franckyi.ibeeditor.client.screen.model.selection.element.ListSelectionElementModel;
import com.github.franckyi.ibeeditor.client.screen.model.selection.element.SortedEnchantmentListSelectionElementModel;
import com.github.franckyi.ibeeditor.client.screen.model.selection.element.SpriteListSelectionElementModel;
import com.github.franckyi.ibeeditor.common.ColoredItemHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1291;
import net.minecraft.class_1320;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1886;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_310;
import net.minecraft.class_5321;

public final class ClientCache {
    private static List<String> itemSuggestions;
    private static List<ItemListSelectionElementModel> itemSelectionItems;
    private static List<String> blockSuggestions;
    private static List<ItemListSelectionElementModel> blockSelectionItems;
    private static List<String> enchantmentSuggestions;
    private static List<EnchantmentListSelectionElementModel> enchantmentSelectionItems;
    private static List<String> attributeSuggestions;
    private static List<ListSelectionElementModel> attributeSelectionItems;
    private static List<String> potionSuggestions;
    private static List<ItemListSelectionElementModel> potionSelectionItems;
    private static List<String> effectSuggestions;
    private static List<SpriteListSelectionElementModel> effectSelectionItems;

    public static List<String> getItemSuggestions() {
        return itemSuggestions == null ? (itemSuggestions = ClientCache.buildSuggestions(class_2378.field_11142)) : itemSuggestions;
    }

    public static List<ItemListSelectionElementModel> getItemSelectionItems() {
        return itemSelectionItems == null ? (itemSelectionItems = ClientCache.buildItemSelectionItems()) : itemSelectionItems;
    }

    public static List<String> getBlockSuggestions() {
        return blockSuggestions == null ? (blockSuggestions = ClientCache.buildSuggestions(class_2378.field_11146)) : blockSuggestions;
    }

    public static List<ItemListSelectionElementModel> getBlockSelectionItems() {
        return blockSelectionItems == null ? (blockSelectionItems = ClientCache.buildBlockSelectionItems()) : blockSelectionItems;
    }

    public static List<String> getEnchantmentSuggestions() {
        return enchantmentSuggestions == null ? (enchantmentSuggestions = ClientCache.buildSuggestions(class_2378.field_11160)) : enchantmentSuggestions;
    }

    public static List<SortedEnchantmentListSelectionElementModel> getSortedEnchantmentSelectionItems(class_1799 target) {
        if (enchantmentSelectionItems == null) {
            enchantmentSelectionItems = ClientCache.buildEnchantmentSelectionItems();
        }
        return enchantmentSelectionItems.stream().map(item -> new SortedEnchantmentListSelectionElementModel((EnchantmentListSelectionElementModel)item, item.getEnchantment().method_8195(), item.getEnchantment().method_8192(target))).sorted((o1, o2) -> {
            if (o1.isCurse()) {
                if (o2.isCurse()) {
                    return o1.getName().compareTo(o2.getName());
                }
                return 1;
            }
            if (o2.isCurse()) {
                return -1;
            }
            if (o1.canApply()) {
                if (o2.canApply()) {
                    return o1.getName().compareTo(o2.getName());
                }
                return -1;
            }
            if (o2.canApply()) {
                return 1;
            }
            return o1.getName().compareTo(o2.getName());
        }).toList();
    }

    public static List<String> getAttributeSuggestions() {
        return attributeSuggestions == null ? (attributeSuggestions = ClientCache.buildSuggestions(class_2378.field_23781)) : attributeSuggestions;
    }

    public static List<ListSelectionElementModel> getAttributeSelectionItems() {
        return attributeSelectionItems == null ? (attributeSelectionItems = ClientCache.buildAttributeSelectionItems()) : attributeSelectionItems;
    }

    public static List<String> getPotionSuggestions() {
        return potionSuggestions == null ? (potionSuggestions = ClientCache.buildSuggestions(class_2378.field_11143)) : potionSuggestions;
    }

    public static List<ItemListSelectionElementModel> getPotionSelectionItems() {
        return potionSelectionItems == null ? (potionSelectionItems = ClientCache.buildPotionSelectionItems()) : potionSelectionItems;
    }

    public static List<String> getEffectSuggestions() {
        return effectSuggestions == null ? (effectSuggestions = ClientCache.buildSuggestions(class_2378.field_11159)) : effectSuggestions;
    }

    public static List<SpriteListSelectionElementModel> getEffectSelectionItems() {
        return effectSelectionItems == null ? (effectSelectionItems = ClientCache.buildEffectSelectionItems()) : effectSelectionItems;
    }

    private static List<String> buildSuggestions(class_2378<?> registry) {
        ArrayList<String> suggestions = new ArrayList<String>();
        registry.method_29722().stream().map(e -> ((class_5321)e.getKey()).method_29177().toString()).forEach(id -> {
            suggestions.add((String)id);
            if (id.startsWith("minecraft:")) {
                suggestions.add(id.substring(10));
            }
        });
        return suggestions;
    }

    private static List<ItemListSelectionElementModel> buildItemSelectionItems() {
        return class_2378.field_11142.method_29722().stream().map(e -> new ItemListSelectionElementModel(((class_1792)e.getValue()).method_7876(), ((class_5321)e.getKey()).method_29177(), new class_1799((class_1935)e.getValue()))).toList();
    }

    private static List<ItemListSelectionElementModel> buildBlockSelectionItems() {
        return class_2378.field_11146.method_29722().stream().map(e -> new ItemListSelectionElementModel(((class_2248)e.getValue()).method_9539(), ((class_5321)e.getKey()).method_29177(), new class_1799((class_1935)e.getValue()))).toList();
    }

    private static List<EnchantmentListSelectionElementModel> buildEnchantmentSelectionItems() {
        return class_2378.field_11160.method_29722().stream().map(e -> new EnchantmentListSelectionElementModel(((class_1887)e.getValue()).method_8184(), ((class_5321)e.getKey()).method_29177(), (class_1887)e.getValue(), new class_1799((class_1935)ClientCache.getEnchantmentTypeItem((class_1887)e.getValue())))).toList();
    }

    private static class_1792 getEnchantmentTypeItem(class_1887 e) {
        class_1886 c = e.field_9083;
        if (c == class_1886.field_9068 || c == class_1886.field_9078) {
            return class_1802.field_8523;
        }
        if (c == class_1886.field_9079) {
            return class_1802.field_8285;
        }
        if (c == class_1886.field_9076) {
            return class_1802.field_8348;
        }
        if (c == class_1886.field_9071) {
            return class_1802.field_8058;
        }
        if (c == class_1886.field_9080) {
            return class_1802.field_8805;
        }
        if (c == class_1886.field_9074) {
            return class_1802.field_8802;
        }
        if (c == class_1886.field_9069) {
            return class_1802.field_8377;
        }
        if (c == class_1886.field_9072) {
            return class_1802.field_8378;
        }
        if (c == class_1886.field_9073) {
            return class_1802.field_8547;
        }
        if (c == class_1886.field_9070) {
            return class_1802.field_8102;
        }
        if (c == class_1886.field_9081) {
            return class_1802.field_8399;
        }
        if (c == class_1886.field_9082 || c == class_1886.field_23747) {
            return class_1802.field_8699;
        }
        return class_1802.field_8162;
    }

    private static List<ListSelectionElementModel> buildAttributeSelectionItems() {
        return class_2378.field_23781.method_29722().stream().map(e -> new ListSelectionElementModel(((class_1320)e.getValue()).method_26830(), ((class_5321)e.getKey()).method_29177())).toList();
    }

    private static List<ItemListSelectionElementModel> buildPotionSelectionItems() {
        return class_2378.field_11143.method_29722().stream().map(e -> new ItemListSelectionElementModel(((class_1842)e.getValue()).method_8051(class_1802.field_8574.method_7876() + ".effect."), ((class_5321)e.getKey()).method_29177(), ColoredItemHelper.createColoredPotionItem(((class_5321)e.getKey()).method_29177(), Integer.MIN_VALUE))).toList();
    }

    private static List<SpriteListSelectionElementModel> buildEffectSelectionItems() {
        return class_2378.field_11159.method_29722().stream().map(e -> new SpriteListSelectionElementModel(((class_1291)e.getValue()).method_5567(), ((class_5321)e.getKey()).method_29177(), () -> class_310.method_1551().method_18505().method_18663((class_1291)e.getValue()))).toList();
    }
}

