/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.context;

import com.github.franckyi.ibeeditor.client.ClientUtil;
import com.github.franckyi.ibeeditor.common.ModTexts;
import java.util.function.Consumer;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;

public abstract class EditorContext<T extends EditorContext<T>> {
    private class_2487 tag;
    protected class_2561 errorTooltip;
    protected boolean canSaveToVault;
    private boolean isSaveToVault = false;
    private boolean isCopyCommand = false;
    private final Consumer<T> action;

    public EditorContext(class_2487 tag, class_2561 errorTooltip, boolean canSaveToVault, Consumer<T> action) {
        this.tag = tag;
        this.errorTooltip = errorTooltip;
        this.canSaveToVault = canSaveToVault;
        this.action = action;
    }

    public class_2487 getTag() {
        return this.tag;
    }

    public void setTag(class_2487 tag) {
        this.tag = tag;
    }

    public class_2561 getErrorTooltip() {
        return this.errorTooltip;
    }

    public boolean hasPermission() {
        return this.errorTooltip == null;
    }

    public void update() {
        if (this.isSaveToVault()) {
            this.saveToVault();
        }
        if (this.isCopyCommand()) {
            class_310.method_1551().field_1774.method_1455(this.getCommand());
            ClientUtil.showMessage((class_2561)ModTexts.Messages.successCopyClipboard(this.getCommandName()));
        }
        if (this.hasPermission()) {
            this.action.accept(this);
        }
    }

    public boolean canSaveToVault() {
        return this.canSaveToVault;
    }

    public boolean isSaveToVault() {
        return this.isSaveToVault;
    }

    public void setSaveToVault(boolean isSaveToVault) {
        this.isSaveToVault = isSaveToVault;
    }

    public boolean isCopyCommand() {
        return this.isCopyCommand;
    }

    public void setCopyCommand(boolean copyCommand) {
        this.isCopyCommand = copyCommand;
    }

    public void saveToVault() {
    }

    public abstract class_5250 getTargetName();

    public class_5250 getCommandTooltip() {
        return ModTexts.copyCommand(this.getCommandName());
    }

    public abstract String getCommandName();

    protected abstract String getCommand();
}

