/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.databindings.api;

import com.github.franckyi.databindings.api.DataBindings;
import com.github.franckyi.databindings.api.DoubleProperty;
import com.github.franckyi.databindings.api.ObservableValue;

public interface ObservableDoubleValue
extends ObservableValue<Double> {
    public static ObservableDoubleValue readOnly(DoubleProperty property) {
        return DataBindings.getPropertyFactory().createReadOnlyProperty(property);
    }

    default public double getValue() {
        return this.get() == null ? 0.0 : (Double)this.get();
    }

    default public ObservableDoubleValue add(double other) {
        return this.mapToDouble(i -> i + other);
    }

    default public ObservableDoubleValue substract(double other) {
        return this.mapToDouble(i -> i - other);
    }

    default public ObservableDoubleValue multiply(double other) {
        return this.mapToDouble(i -> i * other);
    }

    default public ObservableDoubleValue divide(double other) {
        return this.mapToDouble(i -> i / other);
    }

    default public ObservableDoubleValue add(ObservableValue<Double> other) {
        return this.mapToDouble(other, Double::sum);
    }

    default public ObservableDoubleValue substract(ObservableValue<Double> other) {
        return this.mapToDouble(other, (x, y) -> x - y);
    }

    default public ObservableDoubleValue multiply(ObservableValue<Double> other) {
        return this.mapToDouble(other, (x, y) -> x * y);
    }

    default public ObservableDoubleValue divide(ObservableValue<Double> other) {
        return this.mapToDouble(other, (x, y) -> x / y);
    }
}

