/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.databindings.api;

import com.github.franckyi.databindings.api.DataBindings;
import com.github.franckyi.databindings.api.IntegerProperty;
import com.github.franckyi.databindings.api.ObservableValue;

public interface ObservableIntegerValue
extends ObservableValue<Integer> {
    public static ObservableIntegerValue readOnly(IntegerProperty property) {
        return DataBindings.getPropertyFactory().createReadOnlyProperty(property);
    }

    default public int getValue() {
        return this.get() == null ? 0 : (Integer)this.get();
    }

    default public ObservableIntegerValue add(int other) {
        return this.mapToInt(i -> i + other);
    }

    default public ObservableIntegerValue substract(int other) {
        return this.mapToInt(i -> i - other);
    }

    default public ObservableIntegerValue multiply(int other) {
        return this.mapToInt(i -> i * other);
    }

    default public ObservableIntegerValue divide(int other) {
        return this.mapToInt(i -> i / other);
    }

    default public ObservableIntegerValue add(ObservableValue<Integer> other) {
        return this.mapToInt(other, Integer::sum);
    }

    default public ObservableIntegerValue substract(ObservableValue<Integer> other) {
        return this.mapToInt(other, (x, y) -> x - y);
    }

    default public ObservableIntegerValue multiply(ObservableValue<Integer> other) {
        return this.mapToInt(other, (x, y) -> x * y);
    }

    default public ObservableIntegerValue divide(ObservableValue<Integer> other) {
        return this.mapToInt(other, (x, y) -> x / y);
    }
}

