/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.databindings.api;

import com.github.franckyi.databindings.api.DataBindings;
import com.github.franckyi.databindings.api.ObservableBooleanValue;
import com.github.franckyi.databindings.api.ObservableDoubleValue;
import com.github.franckyi.databindings.api.ObservableIntegerValue;
import com.github.franckyi.databindings.api.ObservableObjectValue;
import com.github.franckyi.databindings.api.ObservableStringValue;
import com.github.franckyi.databindings.api.event.ObservableValueChangeListener;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public interface ObservableValue<T> {
    public T get();

    public void addListener(ObservableValueChangeListener<? super T> var1);

    default public ObservableValueChangeListener<? super T> addListener(Consumer<? super T> listener) {
        ObservableValueChangeListener<Object> realListener = (oldVal, newVal) -> listener.accept(newVal);
        this.addListener(realListener);
        return realListener;
    }

    default public ObservableValueChangeListener<? super T> addListener(Runnable listener) {
        ObservableValueChangeListener<Object> realListener = (oldVal, newVal) -> listener.run();
        this.addListener(realListener);
        return realListener;
    }

    public void removeListener(ObservableValueChangeListener<? super T> var1);

    public static <T> ObservableValue<T> unmodifiable(final T value) {
        return new ObservableValue<T>(){

            @Override
            public T get() {
                return value;
            }

            @Override
            public void addListener(ObservableValueChangeListener<? super T> listener) {
            }

            @Override
            public void removeListener(ObservableValueChangeListener<? super T> listener) {
            }
        };
    }

    default public <X> ObservableObjectValue<X> map(Function<T, X> mapper) {
        return DataBindings.getMappingFactory().createMapping(this, mapper);
    }

    default public <X> ObservableObjectValue<X> map(Function<T, X> mapper, X orIfNull) {
        return DataBindings.getMappingFactory().createMapping(this, mapper, orIfNull);
    }

    default public ObservableStringValue mapToString(Function<T, String> mapper) {
        return DataBindings.getMappingFactory().createStringMapping(this, mapper);
    }

    default public ObservableStringValue mapToString(Function<T, String> mapper, String orIfNull) {
        return DataBindings.getMappingFactory().createStringMapping(this, mapper, orIfNull);
    }

    default public ObservableBooleanValue mapToBoolean(Function<T, Boolean> mapper) {
        return DataBindings.getMappingFactory().createBooleanMapping(this, mapper);
    }

    default public ObservableBooleanValue mapToBoolean(Function<T, Boolean> mapper, boolean orIfNull) {
        return DataBindings.getMappingFactory().createBooleanMapping(this, mapper, orIfNull);
    }

    default public ObservableIntegerValue mapToInt(Function<T, Integer> mapper) {
        return DataBindings.getMappingFactory().createIntMapping(this, mapper);
    }

    default public ObservableIntegerValue mapToInt(Function<T, Integer> mapper, int orIfNull) {
        return DataBindings.getMappingFactory().createIntMapping(this, mapper, orIfNull);
    }

    default public ObservableDoubleValue mapToDouble(Function<T, Double> mapper) {
        return DataBindings.getMappingFactory().createDoubleMapping(this, mapper);
    }

    default public ObservableDoubleValue mapToDouble(Function<T, Double> mapper, double orIfNull) {
        return DataBindings.getMappingFactory().createDoubleMapping(this, mapper, orIfNull);
    }

    default public <X> ObservableObjectValue<X> bindMap(Function<T, ObservableValue<X>> mapper) {
        return DataBindings.getMappingFactory().createBoundMapping(this, mapper);
    }

    default public <X> ObservableObjectValue<X> bindMap(Function<T, ObservableValue<X>> mapper, X orIfNull) {
        return DataBindings.getMappingFactory().createBoundMapping(this, mapper, orIfNull);
    }

    default public ObservableStringValue bindMapToString(Function<T, ObservableValue<String>> mapper) {
        return DataBindings.getMappingFactory().createStringBoundMapping(this, mapper);
    }

    default public ObservableStringValue bindMapToString(Function<T, ObservableValue<String>> mapper, String orIfNull) {
        return DataBindings.getMappingFactory().createStringBoundMapping(this, mapper, orIfNull);
    }

    default public ObservableBooleanValue bindMapToBoolean(Function<T, ObservableValue<Boolean>> mapper) {
        return DataBindings.getMappingFactory().createBooleanBoundMapping(this, mapper);
    }

    default public ObservableBooleanValue bindMapToBoolean(Function<T, ObservableValue<Boolean>> mapper, boolean orIfNull) {
        return DataBindings.getMappingFactory().createBooleanBoundMapping(this, mapper, orIfNull);
    }

    default public ObservableIntegerValue bindMapToInt(Function<T, ObservableValue<Integer>> mapper) {
        return DataBindings.getMappingFactory().createIntBoundMapping(this, mapper);
    }

    default public ObservableIntegerValue bindMapToInt(Function<T, ObservableValue<Integer>> mapper, int orIfNull) {
        return DataBindings.getMappingFactory().createIntBoundMapping(this, mapper, orIfNull);
    }

    default public ObservableDoubleValue bindMapToDouble(Function<T, ObservableValue<Double>> mapper) {
        return DataBindings.getMappingFactory().createDoubleBoundMapping(this, mapper);
    }

    default public ObservableDoubleValue bindMapToDouble(Function<T, ObservableValue<Double>> mapper, double orIfNull) {
        return DataBindings.getMappingFactory().createDoubleBoundMapping(this, mapper, orIfNull);
    }

    default public ObservableStringValue mapToString(ObservableValue<T> other, BiFunction<T, T, String> mapper) {
        return DataBindings.getMappingFactory().createStringBiMapping(this, other, mapper);
    }

    default public ObservableBooleanValue mapToBoolean(ObservableValue<T> other, BiFunction<T, T, Boolean> mapper) {
        return DataBindings.getMappingFactory().createBooleanBiMapping(this, other, mapper);
    }

    default public ObservableIntegerValue mapToInt(ObservableValue<T> other, BiFunction<T, T, Integer> mapper) {
        return DataBindings.getMappingFactory().createIntBiMapping(this, other, mapper);
    }

    default public ObservableDoubleValue mapToDouble(ObservableValue<T> other, BiFunction<T, T, Double> mapper) {
        return DataBindings.getMappingFactory().createDoubleBiMapping(this, other, mapper);
    }

    default public ObservableBooleanValue isNull() {
        return this.mapToBoolean(Objects::isNull);
    }

    default public ObservableBooleanValue notNull() {
        return this.mapToBoolean(Objects::nonNull);
    }
}

