/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.api;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public final class RenderHelper {
    private static Minecraft mc() {
        return Minecraft.m_91087_();
    }

    private static Font font() {
        return RenderHelper.mc().f_91062_;
    }

    public static int getFontHeight() {
        Objects.requireNonNull(RenderHelper.font());
        return 9;
    }

    public static int getFontWidth(Component text) {
        return RenderHelper.font().m_92852_((FormattedText)text);
    }

    public static void drawString(PoseStack matrices, Component text, float x, float y, int color, boolean shadow) {
        if (shadow) {
            RenderHelper.font().m_92763_(matrices, text, x, y, color);
        } else {
            RenderHelper.font().m_92889_(matrices, text, x, y, color);
        }
    }

    public static void fillRectangle(PoseStack matrices, int x0, int y0, int x1, int y1, int color) {
        GuiComponent.m_93172_((PoseStack)matrices, (int)x0, (int)y0, (int)x1, (int)y1, (int)color);
    }

    public static void drawVLine(PoseStack matrices, int x, int y0, int y1, int color) {
        RenderHelper.fillRectangle(matrices, x, y0, x + 1, y1, color);
    }

    public static void drawHLine(PoseStack matrices, int y, int x0, int x1, int color) {
        RenderHelper.fillRectangle(matrices, x0, y, x1, y + 1, color);
    }

    public static void drawRectangle(PoseStack matrices, int x0, int y0, int x1, int y1, int color) {
        RenderHelper.drawHLine(matrices, y0, x0, x1 - 1, color);
        RenderHelper.drawVLine(matrices, x1 - 1, y0, y1 - 1, color);
        RenderHelper.drawHLine(matrices, y1 - 1, x1, x0 + 1, color);
        RenderHelper.drawVLine(matrices, x0, y1, y0 + 1, color);
    }

    public static void drawTexture(PoseStack matrices, ResourceLocation id, int x, int y, int width, int height, int imageX, int imageY, int imageWidth, int imageHeight) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)id);
        RenderSystem.m_69478_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        GuiComponent.m_93143_((PoseStack)matrices, (int)x, (int)y, (int)0, (float)imageX, (float)imageY, (int)width, (int)height, (int)imageHeight, (int)imageWidth);
    }

    public static void drawSprite(PoseStack matrices, TextureAtlasSprite sprite, int x, int y, int imageWidth, int imageHeight) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)sprite.m_118414_().m_118330_());
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiComponent.m_93200_((PoseStack)matrices, (int)x, (int)y, (int)0, (int)imageWidth, (int)imageHeight, (TextureAtlasSprite)sprite);
    }

    public static void drawTooltip(PoseStack matrices, List<Component> text, int x, int y) {
        RenderHelper.mc().f_91080_.m_96597_(matrices, text, x, y);
    }

    public static void drawTooltip(PoseStack matrices, ItemStack itemStack, int x, int y) {
        RenderHelper.mc().f_91080_.m_96597_(matrices, itemStack.m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)TooltipFlag.Default.NORMAL), x, y);
    }

    public static void drawItem(ItemStack itemStack, int x, int y) {
        RenderHelper.mc().m_91291_().m_115218_(itemStack, x, y);
    }
}

