/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.api.util;

import com.github.franckyi.guapi.api.node.Node;

public enum Align {
    TOP_LEFT(Vertical.TOP, Horizontal.LEFT),
    TOP_CENTER(Vertical.TOP, Horizontal.CENTER),
    TOP_RIGHT(Vertical.TOP, Horizontal.RIGHT),
    CENTER_LEFT(Vertical.CENTER, Horizontal.LEFT),
    CENTER(Vertical.CENTER, Horizontal.CENTER),
    CENTER_RIGHT(Vertical.CENTER, Horizontal.RIGHT),
    BOTTOM_LEFT(Vertical.BOTTOM, Horizontal.LEFT),
    BOTTOM_CENTER(Vertical.BOTTOM, Horizontal.CENTER),
    BOTTOM_RIGHT(Vertical.BOTTOM, Horizontal.RIGHT);

    private final Vertical verticalAlign;
    private final Horizontal horizontalAlign;

    private Align(Vertical verticalAlign, Horizontal horizontalAlign) {
        this.verticalAlign = verticalAlign;
        this.horizontalAlign = horizontalAlign;
    }

    public Vertical getVerticalAlign() {
        return this.verticalAlign;
    }

    public Horizontal getHorizontalAlign() {
        return this.horizontalAlign;
    }

    public static int getAlignedX(Horizontal align, Node parent, int childWidth) {
        return switch (align) {
            case Horizontal.CENTER -> parent.getX() + parent.getPadding().getLeft() + (parent.getWidth() - parent.getPadding().getHorizontal() - childWidth) / 2;
            case Horizontal.RIGHT -> parent.getX() + parent.getPadding().getLeft() + (parent.getWidth() - parent.getPadding().getHorizontal()) - childWidth;
            case Horizontal.LEFT -> parent.getX() + parent.getPadding().getLeft();
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public static int getAlignedY(Vertical align, Node parent, int childHeight) {
        return switch (align) {
            case Vertical.CENTER -> parent.getY() + parent.getPadding().getTop() + (parent.getHeight() - parent.getPadding().getVertical() - childHeight) / 2;
            case Vertical.BOTTOM -> parent.getY() + parent.getPadding().getTop() + (parent.getHeight() - parent.getPadding().getVertical()) - childHeight;
            case Vertical.TOP -> parent.getY() + parent.getPadding().getTop();
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public static enum Vertical {
        TOP,
        CENTER,
        BOTTOM;

    }

    public static enum Horizontal {
        LEFT,
        CENTER,
        RIGHT;

    }
}

