/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.base;

import com.github.franckyi.databindings.api.IntegerProperty;
import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.franckyi.guapi.api.Guapi;
import com.github.franckyi.guapi.api.ScreenHandler;
import com.github.franckyi.guapi.api.event.ScreenEvent;
import com.github.franckyi.guapi.api.node.Scene;
import com.github.franckyi.guapi.api.util.ScreenEventType;
import com.github.franckyi.guapi.base.event.KeyEventImpl;
import com.github.franckyi.guapi.base.event.MouseButtonEventImpl;
import com.github.franckyi.guapi.base.event.MouseDragEventImpl;
import com.github.franckyi.guapi.base.event.MouseEventImpl;
import com.github.franckyi.guapi.base.event.MouseScrollEventImpl;
import com.github.franckyi.guapi.base.event.TypeEventImpl;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.TextComponent;

public final class ScreenHandlerImpl
implements ScreenHandler {
    public static final ScreenHandler INSTANCE = new ScreenHandlerImpl();
    private final Deque<Scene> scenes = new ArrayDeque<Scene>();
    private final ObjectProperty<Scene> currentSceneProperty = ObjectProperty.create();
    private final IntegerProperty widthProperty = IntegerProperty.create();
    private final IntegerProperty heightProperty = IntegerProperty.create();
    private final Screen screen = new GuapiScreen();
    private Screen oldScreen;

    private ScreenHandlerImpl() {
        this.currentSceneProperty().addListener((oldVal, newVal) -> {
            if (newVal == null) {
                if (oldVal != null) {
                    oldVal.widthProperty().unbind();
                    oldVal.heightProperty().unbind();
                    oldVal.hide();
                }
                this.closeScreen();
            } else {
                if (oldVal == null) {
                    this.openScreen();
                } else {
                    oldVal.hide();
                }
                newVal.widthProperty().unbind();
                newVal.widthProperty().bind(this.widthProperty);
                newVal.heightProperty().unbind();
                newVal.heightProperty().bind(this.heightProperty);
                newVal.show();
            }
        });
    }

    @Override
    public void showScene(Scene scene) {
        this.scenes.push(scene);
        this.setCurrentScene(scene);
    }

    @Override
    public void hideScene() {
        if (!this.scenes.isEmpty()) {
            this.scenes.pop();
            this.setCurrentScene(this.scenes.peek());
        }
    }

    @Override
    public Screen getGuapiScreen() {
        return this.screen;
    }

    private Scene getCurrentScene() {
        return (Scene)this.currentSceneProperty().getValue();
    }

    private ObjectProperty<Scene> currentSceneProperty() {
        return this.currentSceneProperty;
    }

    private void setCurrentScene(Scene value) {
        this.currentSceneProperty().setValue(value);
    }

    private void openScreen() {
        this.oldScreen = Minecraft.m_91087_().f_91080_;
        Minecraft.m_91087_().m_91152_(this.screen);
    }

    private void closeScreen() {
        Minecraft.m_91087_().m_91152_(this.oldScreen);
    }

    private void render(PoseStack matrices, int mouseX, int mouseY, float delta) {
        try {
            this.getCurrentScene().m_6305_(matrices, mouseX, mouseY, delta);
        }
        catch (Exception e) {
            Guapi.getExceptionHandler().handleRenderException(e, matrices, mouseX, mouseY, delta, this.getCurrentScene());
            Guapi.getDefaultLogger().error(Guapi.LOG_MARKER, "Error while rendering GUAPI Scene", (Throwable)e);
            this.hideScene();
        }
    }

    private void tick() {
        if (this.currentSceneProperty().hasValue()) {
            try {
                this.getCurrentScene().tick();
            }
            catch (Exception e) {
                Guapi.getExceptionHandler().handleTickException(e, this.getCurrentScene());
                Guapi.getDefaultLogger().error(Guapi.LOG_MARKER, "Error while ticking GUAPI Scene", (Throwable)e);
                this.hideScene();
            }
        }
    }

    private void updateSize(int width, int height) {
        this.widthProperty.setValue(width);
        this.heightProperty.setValue(height);
    }

    private boolean mouseClicked(double mouseX, double mouseY, int button) {
        return this.handleEvent(ScreenEventType.MOUSE_CLICKED, new MouseButtonEventImpl(mouseX, mouseY, button));
    }

    private boolean mouseReleased(double mouseX, double mouseY, int button) {
        return this.handleEvent(ScreenEventType.MOUSE_RELEASED, new MouseButtonEventImpl(mouseX, mouseY, button));
    }

    private boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.handleEvent(ScreenEventType.MOUSE_DRAGGED, new MouseDragEventImpl(mouseX, mouseY, button, deltaX, deltaY));
    }

    private boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        return this.handleEvent(ScreenEventType.MOUSE_SCOLLED, new MouseScrollEventImpl(mouseX, mouseY, amount));
    }

    private boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return this.handleEvent(ScreenEventType.KEY_PRESSED, new KeyEventImpl(keyCode, scanCode, modifiers));
    }

    private boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        return this.handleEvent(ScreenEventType.KEY_RELEASED, new KeyEventImpl(keyCode, scanCode, modifiers));
    }

    private boolean charTyped(char chr, int modifiers) {
        return this.handleEvent(ScreenEventType.CHAR_TYPED, new TypeEventImpl(chr, modifiers));
    }

    private void mouseMoved(double mouseX, double mouseY) {
        this.handleEvent(ScreenEventType.MOUSE_MOVED, new MouseEventImpl(mouseX, mouseY));
    }

    private <E extends ScreenEvent> boolean handleEvent(ScreenEventType<E> type, E event) {
        if (!this.currentSceneProperty().hasValue()) {
            return false;
        }
        try {
            this.getCurrentScene().handleEvent(type, event);
        }
        catch (Exception e) {
            Guapi.getExceptionHandler().handleEventException(e, type, event, this.getCurrentScene());
            Guapi.getDefaultLogger().error(Guapi.LOG_MARKER, "Error while handling " + type.getName() + " event on GUAPI Scene", (Throwable)e);
            this.hideScene();
        }
        return event.isConsumed();
    }

    private final class GuapiScreen
    extends Screen {
        private GuapiScreen() {
            super(TextComponent.f_131282_);
        }

        public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float partialTicks) {
            if (!ScreenHandlerImpl.this.currentSceneProperty().hasValue()) {
                return;
            }
            if (ScreenHandlerImpl.this.getCurrentScene().isTexturedBackground()) {
                this.m_96626_(0);
            } else {
                this.m_7333_(matrices);
            }
            ScreenHandlerImpl.this.render(matrices, mouseX, mouseY, partialTicks);
        }

        public void m_96624_() {
            ScreenHandlerImpl.this.tick();
        }

        protected void m_7856_() {
            ScreenHandlerImpl.this.updateSize(this.f_96543_, this.f_96544_);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            return ScreenHandlerImpl.this.mouseClicked(mouseX, mouseY, button);
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            return ScreenHandlerImpl.this.mouseReleased(mouseX, mouseY, button);
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            return ScreenHandlerImpl.this.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }

        public boolean m_6050_(double mouseX, double mouseY, double amount) {
            return ScreenHandlerImpl.this.mouseScrolled(mouseX, mouseY, amount);
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            return ScreenHandlerImpl.this.keyPressed(keyCode, scanCode, modifiers);
        }

        public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
            return ScreenHandlerImpl.this.keyReleased(keyCode, scanCode, modifiers);
        }

        public boolean m_5534_(char chr, int modifiers) {
            return ScreenHandlerImpl.this.charTyped(chr, modifiers);
        }

        public void m_94757_(double mouseX, double mouseY) {
            ScreenHandlerImpl.this.mouseMoved(mouseX, mouseY);
        }
    }
}

