/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.base.theme.vanilla.delegate;

import com.github.franckyi.guapi.api.GuapiHelper;
import com.github.franckyi.guapi.api.node.Node;
import com.github.franckyi.guapi.api.node.TexturedButton;
import com.github.franckyi.guapi.api.node.TreeView;
import com.github.franckyi.guapi.api.node.builder.HBoxBuilder;
import com.github.franckyi.guapi.api.node.builder.TexturedButtonBuilder;
import com.github.franckyi.guapi.base.theme.vanilla.delegate.AbstractVanillaListNodeSkinDelegate;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.resources.ResourceLocation;

public class VanillaTreeViewSkinDelegate<E extends TreeView.TreeItem<E>>
extends AbstractVanillaListNodeSkinDelegate<TreeView<E>, E, NodeEntry<E>> {
    public VanillaTreeViewSkinDelegate(TreeView<E> node) {
        super(node);
        node.rootItemProperty().addListener(this::shouldRefreshList);
        node.showRootProperty().addListener(this::shouldRefreshList);
        node.rootItemProperty().bindMapToBoolean(TreeView.TreeItem::childrenChangedProperty, false).addListener(newVal -> {
            if (newVal.booleanValue()) {
                this.shouldRefreshList();
                node.getRoot().setChildrenChanged(false);
            }
        });
    }

    @Override
    protected void createList() {
        if (((TreeView)this.node).rootItemProperty().hasValue()) {
            if (((TreeView)this.node).isShowRoot()) {
                this.addChild(((TreeView)this.node).getRoot(), 0);
            } else {
                for (TreeView.TreeItem child : ((TreeView)this.node).getRoot().getChildren()) {
                    this.addChild(child, 0);
                }
            }
        }
    }

    private void addChild(E item, int increment) {
        NodeEntry<E> entry = new NodeEntry<E>(this, item, ((TreeView)this.node).getRenderer().getView(item), increment);
        this.m_6702_().add(entry);
        if (item == ((TreeView)this.node).getFocusedElement()) {
            this.m_7522_((GuiEventListener)entry);
        }
        ++increment;
        if (item.isExpanded()) {
            for (TreeView.TreeItem child : item.getChildren()) {
                this.addChild(child, increment);
            }
        }
    }

    protected static class NodeEntry<E extends TreeView.TreeItem<E>>
    extends AbstractVanillaListNodeSkinDelegate.NodeEntry<TreeView<E>, E, NodeEntry<E>> {
        private static final ResourceLocation TREE_VIEW_WIDGETS = new ResourceLocation("ibeeditor", "textures/gui/tree_view_widgets.png");
        private TexturedButton button;
        private final int increment;

        public NodeEntry(VanillaTreeViewSkinDelegate<E> list, E item, Node node, int increment) {
            super(list, item);
            this.setNode(GuapiHelper.hBox(root -> {
                if (item.getChildren().isEmpty()) {
                    root.add((Node)GuapiHelper.hBox().prefSize(16, 16));
                } else {
                    this.button = (TexturedButton)((TexturedButtonBuilder)GuapiHelper.texturedButton(TREE_VIEW_WIDGETS, 32, 32, false).prefSize(16, 16)).action(() -> {
                        if (!item.isExpanded()) {
                            this.chainExpand(item);
                        } else {
                            item.setExpanded(false);
                        }
                        list.shouldRefreshList();
                    });
                    root.add(this.button);
                    if (item.isExpanded()) {
                        this.button.setImageX(16);
                    }
                    item.expandedProperty().addListener(newVal -> this.button.setImageX(newVal != false ? 16 : 0));
                }
                ((HBoxBuilder)((HBoxBuilder)((HBoxBuilder)root.add(node)).align(GuapiHelper.CENTER_LEFT)).spacing(5)).setParent(list.node);
            }));
            this.increment = increment;
        }

        private void chainExpand(E item) {
            item.setExpanded(true);
            if (item.getChildren().size() == 1) {
                this.chainExpand((TreeView.TreeItem)item.getChildren().get(0));
            }
        }

        public void m_6311_(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int incr = this.increment * ((TreeView)this.getList().node).getChildrenIncrement();
            entryWidth = this.getList().m_93518_() == 0 ? entryWidth + 6 : entryWidth;
            this.getNode().setX(x + incr);
            this.getNode().setY(y);
            this.getNode().setParentPrefWidth(entryWidth - incr);
            this.getNode().setParentPrefHeight(entryHeight);
            if (this.button != null) {
                this.button.setImageY(this.button.inBounds(mouseX, mouseY) ? 16 : 0);
            }
            this.renderBackground(matrices, x, y, entryWidth, entryHeight);
            while (this.getNode().preRender(matrices, mouseX, mouseY, tickDelta)) {
            }
            this.getNode().m_6305_(matrices, mouseX, mouseY, tickDelta);
        }
    }
}

