/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.base.client;

import com.github.franckyi.guapi.api.Guapi;
import com.github.franckyi.guapi.base.NodeFactoryImpl;
import com.github.franckyi.guapi.base.ScreenHandlerImpl;
import com.github.franckyi.guapi.base.theme.vanilla.VanillaTheme;
import com.github.franckyi.ibeeditor.base.client.ClientConfiguration;
import com.github.franckyi.ibeeditor.base.client.KeyBindings;
import com.github.franckyi.ibeeditor.base.client.ModGuapiExceptionHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ClientInit {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void init() {
        LOGGER.info("Initializing IBE Editor - client");
        Guapi.registerTheme("vanilla", VanillaTheme.INSTANCE);
        Guapi.setNodeFactory(NodeFactoryImpl.INSTANCE);
        Guapi.setScreenHandler(ScreenHandlerImpl.INSTANCE);
        Guapi.setDefaultLogger(LogManager.getLogger((String)"IBE Editor"));
        Guapi.setExceptionHandler(ModGuapiExceptionHandler.INSTANCE);
    }

    public static void setup() {
        LOGGER.info("Setting up IBE Editor - client");
        KeyBindings.init();
        ClientConfiguration.load();
        ClientInit.syncGuapiConfig();
    }

    public static void syncGuapiConfig() {
        Guapi.setDebugMode(ClientConfiguration.INSTANCE.getGuapiDebugMode());
        Guapi.setTheme(ClientConfiguration.INSTANCE.getGuapiTheme());
    }
}

