/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.base.client;

import com.github.franckyi.ibeeditor.base.common.EditorType;
import com.github.franckyi.ibeeditor.base.common.NetworkManager;
import com.github.franckyi.ibeeditor.base.common.Packet;
import com.github.franckyi.ibeeditor.base.common.packet.BlockEditorRequestPacket;
import com.github.franckyi.ibeeditor.base.common.packet.BlockInventoryItemEditorRequestPacket;
import com.github.franckyi.ibeeditor.base.common.packet.BlockInventoryItemUpdatePacket;
import com.github.franckyi.ibeeditor.base.common.packet.BlockUpdatePacket;
import com.github.franckyi.ibeeditor.base.common.packet.ClientNotificationPacket;
import com.github.franckyi.ibeeditor.base.common.packet.EntityEditorRequestPacket;
import com.github.franckyi.ibeeditor.base.common.packet.EntityUpdatePacket;
import com.github.franckyi.ibeeditor.base.common.packet.MainHandItemEditorRequestPacket;
import com.github.franckyi.ibeeditor.base.common.packet.PlayerInventoryItemEditorRequestPacket;
import com.github.franckyi.ibeeditor.base.common.packet.PlayerInventoryItemUpdatePacket;
import com.github.franckyi.ibeeditor.base.common.packet.PlayerMainHandItemUpdatePacket;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ClientNetworkEmitter {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void sendClientNotification() {
        ClientNetworkEmitter.send("ibeeditor:network/client_notification", new ClientNotificationPacket());
    }

    public static void sendPlayerMainHandItemUpdate(ItemStack itemStack) {
        ClientNetworkEmitter.send("ibeeditor:network/player_main_hand_item_update", new PlayerMainHandItemUpdatePacket(itemStack));
    }

    public static void sendPlayerInventoryItemUpdate(ItemStack itemStack, int slotId) {
        ClientNetworkEmitter.send("ibeeditor:network/player_inventory_item_update", new PlayerInventoryItemUpdatePacket(itemStack, slotId));
    }

    public static void sendBlockInventoryItemUpdate(ItemStack itemStack, int slotId, BlockPos blockPos) {
        ClientNetworkEmitter.send("ibeeditor:network/block_inventory_item_update", new BlockInventoryItemUpdatePacket(itemStack, slotId, blockPos));
    }

    public static void sendBlockUpdate(BlockPos pos, BlockState state, CompoundTag tag) {
        ClientNetworkEmitter.send("ibeeditor:network/block_update", new BlockUpdatePacket(pos, state, tag));
    }

    public static void sendEntityUpdate(int entityId, CompoundTag tag) {
        ClientNetworkEmitter.send("ibeeditor:network/entity_update", new EntityUpdatePacket(entityId, tag));
    }

    public static void sendMainHandItemEditorRequest(EditorType type) {
        ClientNetworkEmitter.send("ibeeditor:network/main_hand_item_editor_request", new MainHandItemEditorRequestPacket(type));
    }

    public static void sendPlayerInventoryItemEditorRequest(EditorType type, int slotIndex, boolean isCreativeInventoryScreen) {
        ClientNetworkEmitter.send("ibeeditor:network/player_inventory_item_editor_request", new PlayerInventoryItemEditorRequestPacket(type, slotIndex, isCreativeInventoryScreen));
    }

    public static void sendBlockInventoryItemEditorRequest(EditorType type, int slotIndex, BlockPos pos) {
        ClientNetworkEmitter.send("ibeeditor:network/block_inventory_item_editor_request", new BlockInventoryItemEditorRequestPacket(type, slotIndex, pos));
    }

    public static void sendBlockEditorRequest(BlockPos blockPos, EditorType type) {
        ClientNetworkEmitter.send("ibeeditor:network/block_editor_request", new BlockEditorRequestPacket(type, blockPos));
    }

    public static void sendEntityEditorRequest(int entityId, EditorType type) {
        ClientNetworkEmitter.send("ibeeditor:network/entity_editor_request", new EntityEditorRequestPacket(type, entityId));
    }

    private static void send(String id, Packet packet) {
        LOGGER.debug("Sending packet {} to the server", (Object)id);
        NetworkManager.sendToServer(id, packet);
    }
}

