/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.base.client;

import com.github.franckyi.ibeeditor.base.client.ClientContext;
import com.github.franckyi.ibeeditor.base.client.ClientEditorLogic;
import com.github.franckyi.ibeeditor.base.client.ClientNetworkEmitter;
import com.github.franckyi.ibeeditor.base.common.ModTexts;
import com.github.franckyi.ibeeditor.base.common.packet.BlockEditorResponsePacket;
import com.github.franckyi.ibeeditor.base.common.packet.BlockInventoryItemEditorResponsePacket;
import com.github.franckyi.ibeeditor.base.common.packet.EditorCommandPacket;
import com.github.franckyi.ibeeditor.base.common.packet.EntityEditorResponsePacket;
import com.github.franckyi.ibeeditor.base.common.packet.MainHandItemEditorResponsePacket;
import com.github.franckyi.ibeeditor.base.common.packet.PlayerInventoryItemEditorResponsePacket;
import com.github.franckyi.ibeeditor.base.common.packet.ServerNotificationPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ClientNetworkReceiver {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void onMainHandItemEditorResponse(MainHandItemEditorResponsePacket packet) {
        ClientNetworkReceiver.log("ibeeditor:network/main_hand_item_editor_response");
        ClientEditorLogic.openMainHandItemEditor(packet.getItemStack(), packet.getEditorType());
    }

    public static void onPlayerInventoryItemEditorResponse(PlayerInventoryItemEditorResponsePacket packet) {
        ClientNetworkReceiver.log("ibeeditor:network/player_inventory_item_editor_response");
        ClientEditorLogic.openPlayerInventoryItemEditor(packet.getItemStack(), packet.getEditorType(), packet.getSlotIndex(), packet.isCreativeInventoryScreen());
    }

    public static void onBlockInventoryItemEditorResponse(BlockInventoryItemEditorResponsePacket packet) {
        ClientNetworkReceiver.log("ibeeditor:network/block_inventory_item_editor_response");
        ClientEditorLogic.openBlockInventoryItemEditor(packet.getItemStack(), packet.getEditorType(), packet.getSlotIndex(), packet.getPos());
    }

    public static void onBlockEditorResponse(BlockEditorResponsePacket packet) {
        ClientNetworkReceiver.log("ibeeditor:network/block_editor_response");
        ClientEditorLogic.openBlockEditor(packet.getPos(), packet.getState(), packet.getTag(), packet.getEditorType());
    }

    public static void onEntityEditorResponse(EntityEditorResponsePacket packet) {
        ClientNetworkReceiver.log("ibeeditor:network/entity_editor_response");
        ClientEditorLogic.openEntityEditor(packet.getTag(), packet.getEntityId(), packet.getEditorType());
    }

    public static void onServerNotification(ServerNotificationPacket packet) {
        ClientNetworkReceiver.log("ibeeditor:network/server_notification");
        ClientContext.setModInstalledOnServer(packet.getValue());
        ClientNetworkEmitter.sendClientNotification();
    }

    public static void onEditorCommand(EditorCommandPacket packet) {
        ClientNetworkReceiver.log("ibeeditor:network/editor_command");
        switch (packet.getTarget()) {
            case 0: {
                ClientEditorLogic.openWorldEditor(packet.getType());
                break;
            }
            case 1: {
                if (ClientEditorLogic.tryOpenItemEditor(packet.getType())) break;
                ClientNetworkReceiver.sendMessage((Component)ModTexts.Messages.errorNoTargetFound(ModTexts.ITEM));
                break;
            }
            case 2: {
                if (ClientEditorLogic.tryOpenBlockEditor(packet.getType())) break;
                ClientNetworkReceiver.sendMessage((Component)ModTexts.Messages.errorNoTargetFound(ModTexts.BLOCK));
                break;
            }
            case 3: {
                if (ClientEditorLogic.tryOpenEntityEditor(packet.getType())) break;
                ClientNetworkReceiver.sendMessage((Component)ModTexts.Messages.errorNoTargetFound(ModTexts.ENTITY));
                break;
            }
            case 4: {
                ClientEditorLogic.tryOpenSelfEditor(packet.getType());
            }
        }
    }

    private static void sendMessage(Component message) {
        Minecraft.m_91087_().f_91074_.m_5661_(message, false);
    }

    private static void log(String id) {
        LOGGER.debug("Receiving packet {}", (Object)id);
    }
}

