/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.base.client;

import com.github.franckyi.guapi.api.Guapi;
import com.github.franckyi.guapi.api.GuapiHelper;
import com.github.franckyi.guapi.api.node.Node;
import com.github.franckyi.guapi.api.node.Scene;
import com.github.franckyi.guapi.api.node.builder.SceneBuilder;
import com.github.franckyi.ibeeditor.base.client.ClientConfiguration;
import com.github.franckyi.ibeeditor.base.client.mvc.ColorSelectionScreenMVC;
import com.github.franckyi.ibeeditor.base.client.mvc.ConfigEditorMVC;
import com.github.franckyi.ibeeditor.base.client.mvc.ListSelectionScreenMVC;
import com.github.franckyi.ibeeditor.base.client.mvc.NBTEditorMVC;
import com.github.franckyi.ibeeditor.base.client.mvc.SNBTEditorMVC;
import com.github.franckyi.ibeeditor.base.client.mvc.StandardEditorMVC;
import com.github.franckyi.ibeeditor.base.client.mvc.model.BlockEditorModel;
import com.github.franckyi.ibeeditor.base.client.mvc.model.ColorSelectionScreenModel;
import com.github.franckyi.ibeeditor.base.client.mvc.model.ConfigEditorModel;
import com.github.franckyi.ibeeditor.base.client.mvc.model.EntityEditorModel;
import com.github.franckyi.ibeeditor.base.client.mvc.model.ItemEditorModel;
import com.github.franckyi.ibeeditor.base.client.mvc.model.ListSelectionItemModel;
import com.github.franckyi.ibeeditor.base.client.mvc.model.ListSelectionScreenModel;
import com.github.franckyi.ibeeditor.base.client.mvc.model.NBTEditorModel;
import com.github.franckyi.ibeeditor.base.client.mvc.model.SNBTEditorModel;
import com.github.franckyi.ibeeditor.base.client.util.ScreenScalingManager;
import com.github.franckyi.ibeeditor.base.common.ModTexts;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ModScreenHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void openItemEditorScreen(ItemStack itemStack, Consumer<ItemStack> action, Component disabledTooltip) {
        ModScreenHandler.openScaledScreen(GuapiHelper.mvc(StandardEditorMVC.INSTANCE, new ItemEditorModel(itemStack, action, disabledTooltip)));
    }

    @Deprecated
    public static void openBlockEditorScreen(Pair<BlockState, CompoundTag> block, Consumer<Pair<BlockState, CompoundTag>> action, Component disabledTooltip) {
        ModScreenHandler.openScaledScreen(GuapiHelper.mvc(StandardEditorMVC.INSTANCE, new BlockEditorModel(block, action, disabledTooltip)));
    }

    @Deprecated
    public static void openEntityEditorScreen(CompoundTag entity, Consumer<CompoundTag> action, Component disabledTooltip) {
        ModScreenHandler.openScaledScreen(GuapiHelper.mvc(StandardEditorMVC.INSTANCE, new EntityEditorModel(entity, action, disabledTooltip)));
    }

    public static void openNBTEditorScreen(CompoundTag tag, Consumer<CompoundTag> action, Component disabledTooltip) {
        ModScreenHandler.openScaledScreen(GuapiHelper.mvc(NBTEditorMVC.INSTANCE, new NBTEditorModel(tag, action, disabledTooltip)));
    }

    public static void openSNBTEditorScreen(String snbt, Consumer<String> action, Component disabledTooltip) {
        ModScreenHandler.openScaledScreen(GuapiHelper.mvc(SNBTEditorMVC.INSTANCE, new SNBTEditorModel(snbt, action, disabledTooltip)));
    }

    public static void openSettingsScreen() {
        ModScreenHandler.openScaledScreen(GuapiHelper.mvc(ConfigEditorMVC.INSTANCE, new ConfigEditorModel()));
    }

    public static void openListSelectionScreen(MutableComponent title, String attributeName, List<? extends ListSelectionItemModel> items, Consumer<String> action) {
        ModScreenHandler.openScaledScreen(GuapiHelper.mvc(ListSelectionScreenMVC.INSTANCE, new ListSelectionScreenModel(title, attributeName, items, action)));
    }

    public static void openColorSelectionScreen(ColorSelectionScreenModel.Target target, int color, Consumer<String> action) {
        ModScreenHandler.openScaledScreen(GuapiHelper.mvc(ColorSelectionScreenMVC.INSTANCE, new ColorSelectionScreenModel(target, action, color)));
    }

    private static void openScaledScreen(Node root) {
        try {
            Guapi.getScreenHandler().showScene((Scene)((SceneBuilder)GuapiHelper.scene(root, true, true).show(scene -> {
                ScreenScalingManager.get().setBaseScale(ClientConfiguration.INSTANCE.getEditorScale());
                scene.widthProperty().addListener(ScreenScalingManager.get()::refresh);
                scene.heightProperty().addListener(ScreenScalingManager.get()::refresh);
            })).hide(scene -> {
                ClientConfiguration.INSTANCE.setEditorScale(ScreenScalingManager.get().getScaleAndReset());
                ClientConfiguration.save();
            }));
        }
        catch (Exception e) {
            LOGGER.error("Error while opening screen", (Throwable)e);
            Minecraft.m_91087_().f_91074_.m_5661_((Component)ModTexts.Messages.ERROR_GENERIC, false);
        }
    }

    public static void optimize(PoseStack matrices) {
        GuapiHelper.scene(GuapiHelper.mvc(StandardEditorMVC.INSTANCE, new ItemEditorModel(new ItemStack((ItemLike)Items.f_41852_), item -> {}, null)), true, true).m_6305_(matrices, 0, 0, 0.0f);
    }
}

