/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.base.client.mvc.controller;

import com.github.franckyi.guapi.api.Color;
import com.github.franckyi.guapi.api.Guapi;
import com.github.franckyi.guapi.api.mvc.AbstractController;
import com.github.franckyi.ibeeditor.base.client.mvc.model.ColorSelectionScreenModel;
import com.github.franckyi.ibeeditor.base.client.mvc.view.ColorSelectionScreenView;

public abstract class ColorSelectionScreenController<V extends ColorSelectionScreenView>
extends AbstractController<ColorSelectionScreenModel, V> {
    protected ColorSelectionScreenController(ColorSelectionScreenModel model, V view) {
        super(model, view);
    }

    @Override
    public void bind() {
        ((ColorSelectionScreenView)this.view).getRedSlider().setValue(((ColorSelectionScreenModel)this.model).getRedValue());
        ((ColorSelectionScreenView)this.view).getGreenSlider().setValue(((ColorSelectionScreenModel)this.model).getGreenValue());
        ((ColorSelectionScreenView)this.view).getBlueSlider().setValue(((ColorSelectionScreenModel)this.model).getBlueValue());
        this.softBind(((ColorSelectionScreenView)this.view).getHexField().textProperty(), ((ColorSelectionScreenModel)this.model).hexValueProperty());
        this.softBind(((ColorSelectionScreenView)this.view).getRedSlider().valueProperty(), ((ColorSelectionScreenModel)this.model).redValueProperty());
        this.softBind(((ColorSelectionScreenView)this.view).getGreenSlider().valueProperty(), ((ColorSelectionScreenModel)this.model).greenValueProperty());
        this.softBind(((ColorSelectionScreenView)this.view).getBlueSlider().valueProperty(), ((ColorSelectionScreenModel)this.model).blueValueProperty());
        ((ColorSelectionScreenModel)this.model).redValueProperty().addListener(() -> this.updateColor(true));
        ((ColorSelectionScreenModel)this.model).greenValueProperty().addListener(() -> this.updateColor(true));
        ((ColorSelectionScreenModel)this.model).blueValueProperty().addListener(() -> this.updateColor(true));
        ((ColorSelectionScreenModel)this.model).hexValueProperty().addListener(() -> this.updateColor(false));
        ((ColorSelectionScreenView)this.view).getHexField().setValidator(this::validateHexString);
        ((ColorSelectionScreenView)this.view).getCancelButton().onAction(Guapi.getScreenHandler()::hideScene);
        ((ColorSelectionScreenView)this.view).getDoneButton().onAction(() -> {
            ((ColorSelectionScreenModel)this.getModel()).apply();
            Guapi.getScreenHandler().hideScene();
        });
        this.updateHexFromRGB();
    }

    private void updateColor(boolean rgbChanged) {
        ((ColorSelectionScreenView)this.view).getDoneButton().setDisable(!((ColorSelectionScreenView)this.view).getHexField().isValid());
        if (rgbChanged) {
            this.updateHexFromRGB();
        } else if (((ColorSelectionScreenView)this.view).getHexField().isValid()) {
            this.updateRGBFromHex();
        }
    }

    private void updateHexFromRGB() {
        int red = (int)((ColorSelectionScreenView)this.view).getRedSlider().getValue();
        int green = (int)((ColorSelectionScreenView)this.view).getGreenSlider().getValue();
        int blue = (int)((ColorSelectionScreenView)this.view).getBlueSlider().getValue();
        ((ColorSelectionScreenModel)this.model).setHexValue(String.format("#%02x%02x%02x", red, green, blue));
        this.updateExample();
    }

    private void updateRGBFromHex() {
        String hex = ((ColorSelectionScreenView)this.view).getHexField().getText().substring(1);
        ((ColorSelectionScreenModel)this.model).setRedValue(Integer.valueOf(hex.substring(0, 2), 16).intValue());
        ((ColorSelectionScreenModel)this.model).setGreenValue(Integer.valueOf(hex.substring(2, 4), 16).intValue());
        ((ColorSelectionScreenModel)this.model).setBlueValue(Integer.valueOf(hex.substring(4, 6), 16).intValue());
        this.updateExample();
    }

    protected void updateExample() {
        ((ColorSelectionScreenView)this.view).getExampleBox().setBackgroundColor(Color.fromRGB((int)((ColorSelectionScreenModel)this.model).getRedValue(), (int)((ColorSelectionScreenModel)this.model).getGreenValue(), (int)((ColorSelectionScreenModel)this.model).getBlueValue()));
    }

    private boolean validateHexString(String s) {
        try {
            if (s.length() != 7 || !s.startsWith("#")) {
                return false;
            }
            Integer.parseInt(s.substring(1), 16);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

