/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.base.client.mvc.controller;

import com.github.franckyi.databindings.api.event.ObservableListChangeEvent;
import com.github.franckyi.databindings.api.event.ObservableListChangeListener;
import com.github.franckyi.guapi.api.Guapi;
import com.github.franckyi.guapi.api.mvc.AbstractController;
import com.github.franckyi.ibeeditor.base.client.mvc.model.CategoryModel;
import com.github.franckyi.ibeeditor.base.client.mvc.model.ListEditorModel;
import com.github.franckyi.ibeeditor.base.client.mvc.model.entry.EntryModel;
import com.github.franckyi.ibeeditor.base.client.mvc.view.ListEditorView;
import com.github.franckyi.ibeeditor.base.common.ModTexts;
import java.util.Collection;
import net.minecraft.network.chat.Component;

public abstract class ListEditorController<M extends ListEditorModel<?>, V extends ListEditorView>
extends AbstractController<M, V> {
    private final ObservableListChangeListener<EntryModel> listener = this::onSelectedCategoryEntryChange;

    public ListEditorController(M model, V view) {
        super(model, view);
    }

    @Override
    public void bind() {
        this.updateCategoryList();
        this.updateEntryList(null, ((ListEditorModel)this.model).getSelectedCategory());
        ((ListEditorModel)this.model).getCategories().addListener(this::updateCategoryList);
        ((ListEditorModel)this.model).selectedCategoryProperty().addListener(this::updateEntryList);
        ((ListEditorView)this.view).getDoneButton().onAction(event -> ((ListEditorModel)this.model).apply());
        ((ListEditorModel)this.model).validProperty().addListener(this::onValidationChange);
        ((ListEditorView)this.view).getCancelButton().onAction(Guapi.getScreenHandler()::hideScene);
    }

    private void updateCategoryList() {
        ((ListEditorView)this.view).getCategoryList().getItems().setAll(((ListEditorModel)this.model).getCategories());
    }

    private void updateEntryList(CategoryModel oldValue, CategoryModel newValue) {
        if (oldValue != null) {
            oldValue.getEntries().removeListener(this.listener);
        }
        if (newValue != null) {
            ((ListEditorModel)this.model).getSelectedCategory().getEntries().addListener(this.listener);
            this.onSelectedCategoryEntryChange(null);
        }
    }

    private void onSelectedCategoryEntryChange(ObservableListChangeEvent<? extends EntryModel> event) {
        ((ListEditorView)this.view).getEntryList().getItems().setAll((Collection<EntryModel>)((ListEditorModel)this.model).getSelectedCategory().getEntries());
        ((ListEditorView)this.view).getEntryList().setItemHeight(((ListEditorModel)this.model).getSelectedCategory().getEntryHeight());
    }

    protected void onValidationChange(boolean newVal) {
        ((ListEditorView)this.view).getDoneButton().setDisable(!newVal);
        if (!newVal) {
            if (((ListEditorView)this.view).getDoneButton().getTooltip().isEmpty()) {
                ((ListEditorView)this.view).getDoneButton().getTooltip().add((Component)ModTexts.FIX_ERRORS);
            } else {
                ((ListEditorView)this.view).getDoneButton().getTooltip().set(0, (Component)ModTexts.FIX_ERRORS);
            }
        } else {
            ((ListEditorView)this.view).getDoneButton().getTooltip().clear();
        }
    }
}

