/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.base.client.mvc.model;

import com.github.franckyi.databindings.api.BooleanProperty;
import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.franckyi.databindings.api.ObservableList;
import com.github.franckyi.guapi.api.GuapiHelper;
import com.github.franckyi.guapi.api.mvc.Model;
import com.github.franckyi.ibeeditor.base.client.mvc.model.ListEditorModel;
import com.github.franckyi.ibeeditor.base.client.mvc.model.entry.AddListEntryEntryModel;
import com.github.franckyi.ibeeditor.base.client.mvc.model.entry.EntryModel;
import com.github.franckyi.ibeeditor.base.common.ModTexts;
import java.util.Collections;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public abstract class CategoryModel
implements Model {
    private final ObjectProperty<Component> nameProperty;
    private final BooleanProperty selectedProperty = BooleanProperty.create(false);
    private final BooleanProperty validProperty = BooleanProperty.create(true);
    private final ObservableList<EntryModel> entries = ObservableList.create();
    private final ListEditorModel<?> editor;

    protected CategoryModel(Component name, ListEditorModel<?> editor) {
        this.nameProperty = ObjectProperty.create(name);
        this.editor = editor;
    }

    @Override
    public void initalize() {
        this.setupEntries();
        if (this.hasEntryList()) {
            this.getEntries().add(new AddListEntryEntryModel(this, (Component)ModTexts.addListEntry(this.getAddListEntryButtonTooltip()).m_130940_(ChatFormatting.GREEN)));
        }
        this.updateValidity();
        this.validProperty().addListener(this.getEditor()::updateValidity);
        this.getEntries().addListener(this::updateValidity);
    }

    protected abstract void setupEntries();

    public Component getName() {
        return (Component)this.nameProperty().getValue();
    }

    public ObjectProperty<Component> nameProperty() {
        return this.nameProperty;
    }

    public void setName(Component value) {
        this.nameProperty().setValue(value);
    }

    public boolean isSelected() {
        return this.selectedProperty().getValue();
    }

    public BooleanProperty selectedProperty() {
        return this.selectedProperty;
    }

    public void setSelected(boolean value) {
        this.selectedProperty().setValue(value);
    }

    public boolean isValid() {
        return this.validProperty().getValue();
    }

    public BooleanProperty validProperty() {
        return this.validProperty;
    }

    public void setValid(boolean value) {
        this.validProperty().setValue(value);
    }

    public ListEditorModel<?> getEditor() {
        return this.editor;
    }

    public ObservableList<EntryModel> getEntries() {
        return this.entries;
    }

    public void updateValidity() {
        this.setValid(this.getEntries().stream().allMatch(EntryModel::isValid));
        if (this.hasEntryList()) {
            for (int i = 0; i < this.getEntryListSize(); ++i) {
                EntryModel entry = (EntryModel)this.getEntries().get(this.getEntryListIndex(i));
                entry.setListSize(this.getEntryListSize());
                entry.setListIndex(i);
            }
        }
    }

    public int getEntryListStart() {
        return -1;
    }

    private int getEntryListIndex(int index) {
        return this.getEntryListStart() + index;
    }

    private int getEntryListSize() {
        return this.getEntries().size() - this.getEntryListStart() - 1;
    }

    private boolean hasEntryList() {
        return this.getEntryListStart() >= 0;
    }

    public void addEntryInList() {
        this.getEntries().add(this.getEntries().size() - 1, this.createListEntry());
    }

    public EntryModel createListEntry() {
        return null;
    }

    protected MutableComponent getAddListEntryButtonTooltip() {
        return GuapiHelper.EMPTY_TEXT;
    }

    public void moveEntryUp(int index) {
        Collections.swap(this.getEntries(), this.getEntryListIndex(index), this.getEntryListIndex(index) - 1);
    }

    public void moveEntryDown(int index) {
        Collections.swap(this.getEntries(), this.getEntryListIndex(index), this.getEntryListIndex(index) + 1);
    }

    public void deleteEntry(int index) {
        this.getEntries().remove(this.getEntryListIndex(index));
    }

    public int getEntryHeight() {
        return 25;
    }
}

