/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.base.client.mvc.model;

import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.franckyi.guapi.api.mvc.Model;
import com.github.franckyi.ibeeditor.base.client.mvc.model.NBTTagModel;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;

public class NBTEditorModel
implements Model {
    private final ObjectProperty<NBTTagModel> rootTagProperty;
    private final ObjectProperty<NBTTagModel> clipboardTagProperty = ObjectProperty.create();
    private final Consumer<CompoundTag> action;
    private final Component disabledTooltip;

    public NBTEditorModel(CompoundTag tag, Consumer<CompoundTag> action, Component disabledTooltip) {
        this.rootTagProperty = ObjectProperty.create(new NBTTagModel((Tag)tag));
        this.action = action;
        this.disabledTooltip = disabledTooltip;
    }

    public NBTTagModel getRootTag() {
        return (NBTTagModel)this.rootTagProperty().getValue();
    }

    public ObjectProperty<NBTTagModel> rootTagProperty() {
        return this.rootTagProperty;
    }

    public void setRootTag(NBTTagModel value) {
        this.rootTagProperty().setValue(value);
    }

    public NBTTagModel getClipboardTag() {
        return (NBTTagModel)this.clipboardTagProperty().getValue();
    }

    public ObjectProperty<NBTTagModel> clipboardTagProperty() {
        return this.clipboardTagProperty;
    }

    public void setClipboardTag(NBTTagModel value) {
        this.clipboardTagProperty().setValue(value);
    }

    public boolean canSave() {
        return this.getDisabledTooltip() == null;
    }

    public Component getDisabledTooltip() {
        return this.disabledTooltip;
    }

    public void apply() {
        this.action.accept((CompoundTag)this.getRootTag().build());
    }
}

