/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.base.client.mvc.model.category;

import com.github.franckyi.ibeeditor.base.client.mvc.model.CategoryModel;
import com.github.franckyi.ibeeditor.base.client.mvc.model.ItemEditorModel;
import com.github.franckyi.ibeeditor.base.client.mvc.model.category.ItemCategoryModel;
import com.github.franckyi.ibeeditor.base.client.mvc.model.entry.AttributeModifierEntryModel;
import com.github.franckyi.ibeeditor.base.client.mvc.model.entry.EntryModel;
import com.github.franckyi.ibeeditor.base.common.ModTexts;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ItemAttributeModifiersCategoryModel
extends ItemCategoryModel {
    private ListTag newAttributeModifiers;

    public ItemAttributeModifiersCategoryModel(ItemEditorModel editor) {
        super((Component)ModTexts.ATTRIBUTE_MODIFIERS, editor);
    }

    @Override
    protected void setupEntries() {
        this.getEntries().addAll((Collection<EntryModel>)this.getBaseTag().m_128437_("AttributeModifiers", 10).stream().map(CompoundTag.class::cast).map(this::createModifierEntry).toList());
    }

    @Override
    public int getEntryListStart() {
        return 0;
    }

    @Override
    public int getEntryHeight() {
        return 50;
    }

    @Override
    public EntryModel createListEntry() {
        return this.createModifierEntry(null);
    }

    private EntryModel createModifierEntry(CompoundTag tag) {
        if (tag != null) {
            String attributeName = tag.m_128461_("AttributeName");
            String slot = tag.m_128461_("Slot");
            int operation = tag.m_128451_("Operation");
            double amount = tag.m_128459_("Amount");
            UUID uuid = tag.m_128342_("UUID");
            return new AttributeModifierEntryModel((CategoryModel)this, attributeName, slot, operation, amount, uuid, this::addAttributeModifier);
        }
        return new AttributeModifierEntryModel(this, this::addAttributeModifier);
    }

    @Override
    protected MutableComponent getAddListEntryButtonTooltip() {
        return ModTexts.MODIFIER;
    }

    @Override
    public void apply(CompoundTag nbt) {
        this.newAttributeModifiers = new ListTag();
        super.apply(nbt);
        if (!this.newAttributeModifiers.isEmpty()) {
            this.getNewTag().m_128365_("AttributeModifiers", (Tag)this.newAttributeModifiers);
        } else {
            this.getNewTag().m_128473_("AttributeModifiers");
        }
    }

    private void addAttributeModifier(String attributeName, String slot, int operation, double amount, UUID uuid) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("AttributeName", attributeName);
        if (!"all".equals(slot)) {
            tag.m_128359_("Slot", slot);
        }
        tag.m_128405_("Operation", operation);
        tag.m_128347_("Amount", amount);
        tag.m_128362_("UUID", uuid);
        this.newAttributeModifiers.add((Object)tag);
    }
}

