/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.base.client.mvc.model.category;

import com.github.franckyi.ibeeditor.base.client.mvc.model.CategoryModel;
import com.github.franckyi.ibeeditor.base.client.mvc.model.ItemEditorModel;
import com.github.franckyi.ibeeditor.base.client.mvc.model.category.ItemCategoryModel;
import com.github.franckyi.ibeeditor.base.client.mvc.model.entry.HideFlagEntryModel;
import com.github.franckyi.ibeeditor.base.common.ModTexts;
import java.util.Locale;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ItemHideFlagsCategoryModel
extends ItemCategoryModel {
    private int newHideFlags;

    public ItemHideFlagsCategoryModel(ItemEditorModel editor) {
        super((Component)ModTexts.HIDE_FLAGS, editor);
    }

    @Override
    protected void setupEntries() {
        int hideFlags = this.getBaseTag().m_128451_("HideFlags");
        for (HideFlag flag : HideFlag.values()) {
            this.getEntries().add(new HideFlagEntryModel((CategoryModel)this, flag, (hideFlags & flag.getValue()) > 0, value -> this.setFlag(flag, (boolean)value)));
        }
    }

    @Override
    public void apply(CompoundTag nbt) {
        this.newHideFlags = 0;
        super.apply(nbt);
        if (this.newHideFlags > 0) {
            this.getNewTag().m_128405_("HideFlags", this.newHideFlags);
        } else {
            this.getNewTag().m_128473_("HideFlags");
        }
    }

    private void setFlag(HideFlag flag, boolean value) {
        if (value) {
            this.newHideFlags += flag.getValue();
        }
    }

    public static enum HideFlag {
        ENCHANTMENTS,
        ATTRIBUTE_MODIFIERS,
        UNBREAKABLE,
        CAN_DESTROY,
        CAN_PLACE_ON,
        OTHER,
        DYED;


        public MutableComponent getName() {
            return ModTexts.gui(this.name().toLowerCase(Locale.ROOT));
        }

        public int getValue() {
            return (int)Math.pow(2.0, this.ordinal());
        }
    }
}

