/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.base.client.mvc.view;

import com.github.franckyi.databindings.api.BooleanProperty;
import com.github.franckyi.guapi.api.GuapiHelper;
import com.github.franckyi.guapi.api.node.HBox;
import com.github.franckyi.guapi.api.node.Node;
import com.github.franckyi.guapi.api.node.TexturedButton;
import com.github.franckyi.guapi.api.node.builder.HBoxBuilder;
import com.github.franckyi.guapi.api.node.builder.TexturedButtonBuilder;
import com.github.franckyi.ibeeditor.base.client.ModTextures;
import com.github.franckyi.ibeeditor.base.client.mvc.view.ListEditorView;
import com.github.franckyi.ibeeditor.base.client.util.texteditor.StyleType;
import com.github.franckyi.ibeeditor.base.client.util.texteditor.TextEditorActionHandler;
import com.github.franckyi.ibeeditor.base.common.ModTexts;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class StandardEditorView
extends ListEditorView {
    private List<TexturedButton> colorButtons;
    private TexturedButton customColorButton;
    private TexturedButtonBuilder chooseCustomColorButton;
    private HBox textButtons;
    private HBox buttons;
    private final BooleanProperty showTextButtonsProperty = BooleanProperty.create();
    private Supplier<TextEditorActionHandler> textEditorSupplier;

    @Override
    public void build() {
        super.build();
        this.colorButtons = Arrays.asList(this.createTextColorButton("black", ModTextures.COLOR_BLACK, ModTexts.BLACK), this.createTextColorButton("dark_blue", ModTextures.COLOR_DARK_BLUE, ModTexts.DARK_BLUE), this.createTextColorButton("dark_green", ModTextures.COLOR_DARK_GREEN, ModTexts.DARK_GREEN), this.createTextColorButton("dark_aqua", ModTextures.COLOR_DARK_AQUA, ModTexts.DARK_AQUA), this.createTextColorButton("dark_red", ModTextures.COLOR_DARK_RED, ModTexts.DARK_RED), this.createTextColorButton("dark_purple", ModTextures.COLOR_DARK_PURPLE, ModTexts.DARK_PURPLE), this.createTextColorButton("gold", ModTextures.COLOR_GOLD, ModTexts.GOLD), this.createTextColorButton("gray", ModTextures.COLOR_GRAY, ModTexts.GRAY), this.createTextColorButton("dark_gray", ModTextures.COLOR_DARK_GRAY, ModTexts.DARK_GRAY), this.createTextColorButton("blue", ModTextures.COLOR_BLUE, ModTexts.BLUE), this.createTextColorButton("green", ModTextures.COLOR_GREEN, ModTexts.GREEN), this.createTextColorButton("aqua", ModTextures.COLOR_AQUA, ModTexts.AQUA), this.createTextColorButton("red", ModTextures.COLOR_RED, ModTexts.RED), this.createTextColorButton("light_purple", ModTextures.COLOR_LIGHT_PURPLE, ModTexts.LIGHT_PURPLE), this.createTextColorButton("yellow", ModTextures.COLOR_YELLOW, ModTexts.YELLOW), this.createTextColorButton("white", ModTextures.COLOR_WHITE, ModTexts.WHITE));
        this.textButtons = (HBox)GuapiHelper.hBox(buttons -> {
            buttons.add(GuapiHelper.hBox(middle -> {
                middle.add(this.createTextButton(StyleType.BOLD, ModTextures.TEXT_BOLD, ModTexts.BOLD));
                middle.add(this.createTextButton(StyleType.ITALIC, ModTextures.TEXT_ITALIC, ModTexts.ITALIC));
                middle.add(this.createTextButton(StyleType.UNDERLINED, ModTextures.TEXT_UNDERLINED, ModTexts.UNDERLINED));
                middle.add(this.createTextButton(StyleType.STRIKETHROUGH, ModTextures.TEXT_STRIKETHROUGH, ModTexts.STRIKETHROUGH));
                middle.add(this.createTextButton(StyleType.OBFUSCATED, ModTextures.TEXT_OBFUSCATED, ModTexts.OBFUSCATED));
                middle.spacing(2);
            }));
            buttons.add(GuapiHelper.hBox(right -> {
                right.add((Node)((TexturedButtonBuilder)GuapiHelper.texturedButton(ModTextures.RESET_COLOR, 7, 16, false).tooltip(new Component[]{ModTexts.RESET_COLOR})).action(e -> {
                    if (this.textEditorSupplier != null) {
                        e.consume();
                        this.textEditorSupplier.get().removeColorFormatting();
                    }
                }));
                right.add(GuapiHelper.vBox(colors -> {
                    colors.add(GuapiHelper.hBox(2, this.colorButtons.subList(0, this.colorButtons.size() / 2)));
                    colors.add(GuapiHelper.hBox(2, this.colorButtons.subList(this.colorButtons.size() / 2, this.colorButtons.size())));
                    colors.spacing(2);
                }));
                this.customColorButton = (TexturedButton)((TexturedButtonBuilder)((TexturedButtonBuilder)GuapiHelper.texturedButton(null, 1, 1, false).prefSize(7, 16)).visible(false)).tooltip(new Component[]{ModTexts.CUSTOM_COLOR});
                right.add(this.customColorButton);
                this.chooseCustomColorButton = (TexturedButtonBuilder)GuapiHelper.texturedButton(ModTextures.COLOR_CUSTOM, 16, 16, false).tooltip(new Component[]{ModTexts.choose(ModTexts.CUSTOM_COLOR)});
                right.add(this.chooseCustomColorButton);
                right.spacing(2);
            }));
            ((HBoxBuilder)buttons.spacing(12)).padding(GuapiHelper.right(20));
        }).align(GuapiHelper.CENTER_RIGHT);
        this.showTextButtonsProperty().addListener(newVal -> {
            if (newVal.booleanValue()) {
                this.buttons.getChildren().add(0, this.textButtons);
                this.buttons.setWeight(this.textButtons, 1);
            } else {
                this.buttons.getChildren().remove(this.textButtons);
            }
        });
    }

    @Override
    protected Node createButtonBar() {
        this.buttons = (HBox)super.createButtonBar();
        return this.buttons;
    }

    private TexturedButtonBuilder createTextButton(StyleType target, ResourceLocation id, MutableComponent tooltipText) {
        return (TexturedButtonBuilder)((TexturedButtonBuilder)GuapiHelper.texturedButton(id, 16, 16, false).tooltip(new Component[]{tooltipText})).action(e -> {
            if (this.textEditorSupplier != null) {
                e.consume();
                this.textEditorSupplier.get().addStyleFormatting(target);
            }
        });
    }

    private TexturedButtonBuilder createTextColorButton(String color, ResourceLocation id, MutableComponent tooltipText) {
        return (TexturedButtonBuilder)((TexturedButtonBuilder)GuapiHelper.texturedButton(id, 7, 7, false).tooltip(new Component[]{tooltipText})).action(e -> {
            if (this.textEditorSupplier != null) {
                e.consume();
                this.textEditorSupplier.get().addColorFormatting(color);
            }
        });
    }

    public TexturedButton getCustomColorButton() {
        return this.customColorButton;
    }

    public TexturedButton getChooseCustomColorButton() {
        return this.chooseCustomColorButton;
    }

    public boolean isShowTextButtons() {
        return this.showTextButtonsProperty().getValue();
    }

    public BooleanProperty showTextButtonsProperty() {
        return this.showTextButtonsProperty;
    }

    public void setShowTextButtons(boolean value) {
        this.showTextButtonsProperty().setValue(value);
    }

    public void setTextEditorSupplier(Supplier<TextEditorActionHandler> supplier) {
        this.textEditorSupplier = supplier;
    }
}

