/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.base.server;

import com.github.franckyi.guapi.api.GuapiHelper;
import com.github.franckyi.ibeeditor.base.common.CommonConfiguration;
import com.github.franckyi.ibeeditor.base.common.EditorType;
import com.github.franckyi.ibeeditor.base.server.ServerContext;
import com.github.franckyi.ibeeditor.base.server.ServerNetworkEmitter;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ServerCommandHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final MutableComponent MUST_INSTALL = GuapiHelper.text("You must install IBE Editor in order to use this command.").m_130940_(ChatFormatting.RED);
    private static final MutableComponent DOWNLOAD = GuapiHelper.text("Click here to download the mod!").m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/ibe-editor"))).m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.UNDERLINE});
    private static final MutableComponent NO_PERMISSION = GuapiHelper.text("You must be in creative mode to use this command.").m_130940_(ChatFormatting.RED);

    public static void registerCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder subCommand;
        LOGGER.debug("Registering /ibe command");
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.m_82127_((String)"ibe").executes(ServerCommandHandler.createCommand(p -> EditorTargetArgument.DEFAULT.apply((ServerPlayer)p, EditorTypeArgument.DEFAULT)));
        for (EditorTypeArgument editorTypeArgument : EditorTypeArgument.values()) {
            subCommand = (LiteralArgumentBuilder)Commands.m_82127_((String)editorTypeArgument.literal).executes(ServerCommandHandler.createCommand(p -> EditorTargetArgument.DEFAULT.apply((ServerPlayer)p, typeArg.type)));
            for (EditorTargetArgument editorTargetArgument : EditorTargetArgument.values()) {
                subCommand.then(Commands.m_82127_((String)editorTargetArgument.literal).executes(ServerCommandHandler.createCommand(p -> targetArg.target.apply((ServerPlayer)p, typeArg.type))));
            }
            command.then((ArgumentBuilder)subCommand);
        }
        for (Enum enum_ : EditorTargetArgument.values()) {
            subCommand = (LiteralArgumentBuilder)Commands.m_82127_((String)((EditorTargetArgument)enum_).literal).executes(ServerCommandHandler.createCommand(arg_0 -> ServerCommandHandler.lambda$registerCommand$4((EditorTargetArgument)enum_, arg_0)));
            for (Enum enum_2 : EditorTypeArgument.values()) {
                subCommand.then(Commands.m_82127_((String)((EditorTypeArgument)enum_2).literal).executes(ServerCommandHandler.createCommand(arg_0 -> ServerCommandHandler.lambda$registerCommand$5((EditorTargetArgument)enum_, (EditorTypeArgument)enum_2, arg_0))));
            }
            command.then((ArgumentBuilder)subCommand);
        }
        command.requires(source -> source.m_6761_(CommonConfiguration.INSTANCE.getPermissionLevel()));
        dispatcher.register(command);
    }

    private static Command<CommandSourceStack> createCommand(Function<ServerPlayer, Integer> command) {
        return ctx -> (Integer)command.apply(((CommandSourceStack)ctx.getSource()).m_81375_());
    }

    private static int commandOpenWorldEditor(ServerPlayer player, EditorType type) {
        LOGGER.debug("{} issued a world editor command with type={}", (Object)player.m_36316_().getName(), (Object)type);
        return ServerCommandHandler.commandOpenEditor(player, type, ServerNetworkEmitter::sendWorldEditorCommand);
    }

    private static int commandOpenItemEditor(ServerPlayer player, EditorType type) {
        LOGGER.debug("{} issued an item editor command with type={}", (Object)player.m_36316_().getName(), (Object)type);
        return ServerCommandHandler.commandOpenEditor(player, type, ServerNetworkEmitter::sendItemEditorCommand);
    }

    private static int commandOpenBlockEditor(ServerPlayer player, EditorType type) {
        LOGGER.debug("{} issued a block editor command with type={}", (Object)player.m_36316_().getName(), (Object)type);
        return ServerCommandHandler.commandOpenEditor(player, type, ServerNetworkEmitter::sendBlockEditorCommand);
    }

    private static int commandOpenEntityEditor(ServerPlayer player, EditorType type) {
        LOGGER.debug("{} issued an entity editor command with type={}", (Object)player.m_36316_().getName(), (Object)type);
        return ServerCommandHandler.commandOpenEditor(player, type, ServerNetworkEmitter::sendEntityEditorCommand);
    }

    private static int commandOpenSelfEditor(ServerPlayer player, EditorType type) {
        LOGGER.debug("{} issued a self editor command with type={}", (Object)player.m_36316_().getName(), (Object)type);
        return ServerCommandHandler.commandOpenEditor(player, type, ServerNetworkEmitter::sendSelfEditorCommand);
    }

    private static int commandOpenEditor(ServerPlayer player, EditorType type, BiConsumer<ServerPlayer, EditorType> action) {
        if (ServerContext.isClientModded(player)) {
            if (CommonConfiguration.INSTANCE.isCreativeOnly() && !player.m_7500_()) {
                player.m_5661_((Component)NO_PERMISSION, false);
                return 2;
            }
            action.accept(player, type);
            return 0;
        }
        player.m_5661_((Component)MUST_INSTALL, false);
        player.m_5661_((Component)DOWNLOAD, false);
        return 1;
    }

    private static /* synthetic */ Integer lambda$registerCommand$5(EditorTargetArgument targetArg, EditorTypeArgument typeArg, ServerPlayer p) {
        return targetArg.target.apply(p, typeArg.type);
    }

    private static /* synthetic */ Integer lambda$registerCommand$4(EditorTargetArgument targetArg, ServerPlayer p) {
        return targetArg.target.apply(p, EditorTypeArgument.DEFAULT);
    }

    private static enum EditorTypeArgument {
        NBT("nbt", EditorType.NBT),
        SNBT("snbt", EditorType.SNBT);

        private static final EditorType DEFAULT;
        private final String literal;
        private final EditorType type;

        private EditorTypeArgument(String literal, EditorType type) {
            this.literal = literal;
            this.type = type;
        }

        static {
            DEFAULT = EditorType.STANDARD;
        }
    }

    private static enum EditorTargetArgument {
        ITEM("item", ServerCommandHandler::commandOpenItemEditor),
        BLOCK("block", ServerCommandHandler::commandOpenBlockEditor),
        ENTITY("entity", ServerCommandHandler::commandOpenEntityEditor),
        SELF("self", ServerCommandHandler::commandOpenSelfEditor);

        private static final BiFunction<ServerPlayer, EditorType, Integer> DEFAULT;
        private final String literal;
        private final BiFunction<ServerPlayer, EditorType, Integer> target;

        private EditorTargetArgument(String literal, BiFunction<ServerPlayer, EditorType, Integer> target) {
            this.literal = literal;
            this.target = target;
        }

        static {
            DEFAULT = ServerCommandHandler::commandOpenWorldEditor;
        }
    }
}

