/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.base.server;

import com.github.franckyi.ibeeditor.base.common.EditorType;
import com.github.franckyi.ibeeditor.base.common.NetworkManager;
import com.github.franckyi.ibeeditor.base.common.Packet;
import com.github.franckyi.ibeeditor.base.common.packet.BlockEditorResponsePacket;
import com.github.franckyi.ibeeditor.base.common.packet.BlockInventoryItemEditorResponsePacket;
import com.github.franckyi.ibeeditor.base.common.packet.EditorCommandPacket;
import com.github.franckyi.ibeeditor.base.common.packet.EntityEditorResponsePacket;
import com.github.franckyi.ibeeditor.base.common.packet.MainHandItemEditorResponsePacket;
import com.github.franckyi.ibeeditor.base.common.packet.PlayerInventoryItemEditorResponsePacket;
import com.github.franckyi.ibeeditor.base.common.packet.ServerNotificationPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ServerNetworkEmitter {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void sendServerNotification(ServerPlayer player) {
        ServerNetworkEmitter.send("ibeeditor:network/server_notification", player, new ServerNotificationPacket());
    }

    public static void sendMainHandItemEditorResponse(ServerPlayer player, EditorType editorType, ItemStack itemStack) {
        ServerNetworkEmitter.send("ibeeditor:network/main_hand_item_editor_response", player, new MainHandItemEditorResponsePacket(editorType, itemStack));
    }

    public static void sendPlayerInventoryItemEditorResponse(ServerPlayer player, EditorType editorType, int slotIndex, boolean isCreativeInventoryScreen, ItemStack itemStack) {
        ServerNetworkEmitter.send("ibeeditor:network/player_inventory_item_editor_response", player, new PlayerInventoryItemEditorResponsePacket(editorType, slotIndex, isCreativeInventoryScreen, itemStack));
    }

    public static void sendBlockInventoryItemEditorResponse(ServerPlayer player, EditorType editorType, int slotIndex, BlockPos pos, ItemStack itemStack) {
        ServerNetworkEmitter.send("ibeeditor:network/block_inventory_item_editor_response", player, new BlockInventoryItemEditorResponsePacket(editorType, slotIndex, pos, itemStack));
    }

    public static void sendBlockEditorResponse(ServerPlayer player, EditorType editorType, BlockPos pos, BlockState state, CompoundTag tag) {
        ServerNetworkEmitter.send("ibeeditor:network/block_editor_response", player, new BlockEditorResponsePacket(editorType, pos, state, tag));
    }

    public static void sendEntityEditorResponse(ServerPlayer player, EditorType editorType, int entityId, CompoundTag tag) {
        ServerNetworkEmitter.send("ibeeditor:network/entity_editor_response", player, new EntityEditorResponsePacket(editorType, entityId, tag));
    }

    public static void sendWorldEditorCommand(ServerPlayer player, EditorType editorType) {
        ServerNetworkEmitter.sendEditorCommand(player, (byte)0, editorType);
    }

    public static void sendItemEditorCommand(ServerPlayer player, EditorType editorType) {
        ServerNetworkEmitter.sendEditorCommand(player, (byte)1, editorType);
    }

    public static void sendBlockEditorCommand(ServerPlayer player, EditorType editorType) {
        ServerNetworkEmitter.sendEditorCommand(player, (byte)2, editorType);
    }

    public static void sendEntityEditorCommand(ServerPlayer player, EditorType editorType) {
        ServerNetworkEmitter.sendEditorCommand(player, (byte)3, editorType);
    }

    public static void sendSelfEditorCommand(ServerPlayer player, EditorType editorType) {
        ServerNetworkEmitter.sendEditorCommand(player, (byte)4, editorType);
    }

    private static void sendEditorCommand(ServerPlayer player, byte target, EditorType editorType) {
        ServerNetworkEmitter.send("ibeeditor:network/editor_command", player, new EditorCommandPacket(target, editorType));
    }

    private static void send(String id, ServerPlayer player, Packet packet) {
        LOGGER.debug("Sending packet {} to player {}", (Object)id, (Object)player.m_36316_().getName());
        NetworkManager.sendToClient(id, player, packet);
    }
}

