/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.databindings.api;

import com.github.franckyi.databindings.api.DataBindings;
import com.github.franckyi.databindings.api.event.ObservableListChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public interface ObservableList<E>
extends List<E> {
    public static <E> ObservableList<E> create() {
        return DataBindings.getObservableListFactory().createObservableArrayList();
    }

    public void addListener(ObservableListChangeListener<? super E> var1);

    public void removeListener(ObservableListChangeListener<? super E> var1);

    default public ObservableListChangeListener<? super E> addListener(Runnable listener) {
        ObservableListChangeListener realListener = event -> listener.run();
        this.addListener(realListener);
        return realListener;
    }

    default public boolean addAll(E ... elements) {
        return this.addAll(Arrays.asList(elements));
    }

    default public boolean addAll(int index, E ... elements) {
        return this.addAll(index, Arrays.asList(elements));
    }

    default public boolean removeAll(E ... elements) {
        return this.removeAll((Collection<?>)Arrays.asList(elements));
    }

    default public void setAll(E ... elements) {
        this.setAll((Collection<? extends E>)Arrays.asList(elements));
    }

    default public void setAll(Collection<? extends E> c) {
        this.clear();
        this.addAll(c);
    }
}

