/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.databindings.base;

import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.franckyi.databindings.api.ObservableValue;
import com.github.franckyi.databindings.api.Property;
import com.github.franckyi.databindings.api.event.ObservableValueChangeListener;
import java.util.function.BiFunction;

public abstract class AbstractBiMappedObservableValue<T, X, Y>
implements ObservableValue<Y>,
ObservableValueChangeListener<T> {
    private final ObservableValueChangeListener<? super T> aListener;
    private final ObservableValueChangeListener<? super X> bListener;
    private final ObservableValue<T> a;
    private final ObservableValue<X> b;
    private final BiFunction<T, X, Y> mapper;
    private final Property<Y> value = ObjectProperty.create();

    public AbstractBiMappedObservableValue(ObservableValue<T> a, ObservableValue<X> b, BiFunction<T, X, Y> mapper) {
        this.a = a;
        this.b = b;
        this.mapper = mapper;
        this.update();
        this.aListener = a.addListener(this::update);
        this.bListener = b.addListener(this::update);
    }

    @Override
    public Y get() {
        return (Y)this.value.get();
    }

    @Override
    public void addListener(ObservableValueChangeListener<? super Y> listener) {
        this.value.addListener(listener);
    }

    @Override
    public void removeListener(ObservableValueChangeListener<? super Y> listener) {
        this.value.removeListener(listener);
    }

    @Override
    public void onValueChange(T oldVal, T newVal) {
        this.update();
    }

    private void update() {
        this.value.set(this.mapper.apply(this.a.get(), this.b.get()));
    }

    protected void finalize() {
        this.a.removeListener(this.aListener);
        this.b.removeListener(this.bListener);
    }

    public String toString() {
        return this.value.toString();
    }
}

