/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.databindings.base;

import com.github.franckyi.databindings.api.ObservableValue;
import com.github.franckyi.databindings.api.Property;
import com.github.franckyi.databindings.api.event.ObservableValueChangeListener;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AbstractProperty<T>
implements Property<T> {
    protected final List<ObservableValueChangeListener<? super T>> listeners = new CopyOnWriteArrayList<ObservableValueChangeListener<? super T>>();
    protected T value;
    protected final ObservableValueChangeListener<T> valueListener = (oldVal, newVal) -> this.doSet(newVal);
    protected ObservableValue<? extends T> boundValue;

    protected AbstractProperty() {
        this(null);
    }

    protected AbstractProperty(T value) {
        this.value = value;
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public void set(T value) {
        if (!(!this.isBound() || this.boundValue instanceof Property && ((Property)this.boundValue).isBound())) {
            throw new IllegalStateException("Property is bound to a value and cannot be set");
        }
        this.doSet(value);
    }

    protected void doSet(T value) {
        if (!Objects.equals(this.value, value)) {
            Object old = this.value;
            this.value = value;
            this.listeners.forEach(listener -> listener.onValueChange(old, value));
        }
    }

    @Override
    public void addListener(ObservableValueChangeListener<? super T> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ObservableValueChangeListener<? super T> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean isBound() {
        return this.boundValue != null;
    }

    @Override
    public void bind(ObservableValue<? extends T> value) {
        if (this.isBound()) {
            throw new IllegalStateException("Cannot bind property: already bound");
        }
        this.set(value.get());
        value.addListener(this.valueListener);
        this.boundValue = value;
    }

    @Override
    public void unbind() {
        if (this.isBound()) {
            this.boundValue.removeListener(this.valueListener);
            this.boundValue = null;
        }
    }

    @Override
    public void bindBidirectional(Property<T> other) {
        if (this.isBound() || other.isBound()) {
            throw new IllegalStateException("Cannot bind property: already bound");
        }
        this.bind(other);
        other.bind(this);
    }

    @Override
    public void unbindBidirectional(Property<T> other) {
        if (this.boundValue != other) {
            throw new IllegalArgumentException("Cannot unbind property: incorrect value");
        }
        if (this.isBound() && other.isBound()) {
            this.unbind();
            other.unbind();
        }
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

