/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.databindings.base.factory;

import com.github.franckyi.databindings.api.BooleanProperty;
import com.github.franckyi.databindings.api.DoubleProperty;
import com.github.franckyi.databindings.api.IntegerProperty;
import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.franckyi.databindings.api.ObservableBooleanValue;
import com.github.franckyi.databindings.api.ObservableDoubleValue;
import com.github.franckyi.databindings.api.ObservableIntegerValue;
import com.github.franckyi.databindings.api.ObservableObjectValue;
import com.github.franckyi.databindings.api.ObservableStringValue;
import com.github.franckyi.databindings.api.StringProperty;
import com.github.franckyi.databindings.api.factory.PropertyFactory;
import com.github.franckyi.databindings.base.ReadOnlyBooleanProperty;
import com.github.franckyi.databindings.base.ReadOnlyDoubleProperty;
import com.github.franckyi.databindings.base.ReadOnlyIntegerProperty;
import com.github.franckyi.databindings.base.ReadOnlyObjectProperty;
import com.github.franckyi.databindings.base.ReadOnlyStringProperty;
import com.github.franckyi.databindings.base.SimpleBooleanProperty;
import com.github.franckyi.databindings.base.SimpleDoubleProperty;
import com.github.franckyi.databindings.base.SimpleIntegerProperty;
import com.github.franckyi.databindings.base.SimpleObjectProperty;
import com.github.franckyi.databindings.base.SimpleStringProperty;

public class PropertyFactoryImpl
implements PropertyFactory {
    public static final PropertyFactory INSTANCE = new PropertyFactoryImpl();

    protected PropertyFactoryImpl() {
    }

    @Override
    public <T> ObjectProperty<T> createObjectProperty() {
        return new SimpleObjectProperty();
    }

    @Override
    public <T> ObjectProperty<T> createObjectProperty(T value) {
        return new SimpleObjectProperty<T>(value);
    }

    @Override
    public StringProperty createStringProperty() {
        return new SimpleStringProperty();
    }

    @Override
    public StringProperty createStringProperty(String value) {
        return new SimpleStringProperty(value);
    }

    @Override
    public BooleanProperty createBooleanProperty() {
        return new SimpleBooleanProperty();
    }

    @Override
    public BooleanProperty createBooleanProperty(boolean value) {
        return new SimpleBooleanProperty(value);
    }

    @Override
    public IntegerProperty createIntegerProperty() {
        return new SimpleIntegerProperty();
    }

    @Override
    public IntegerProperty createIntegerProperty(int value) {
        return new SimpleIntegerProperty(value);
    }

    @Override
    public DoubleProperty createDoubleProperty() {
        return new SimpleDoubleProperty();
    }

    @Override
    public DoubleProperty createDoubleProperty(double value) {
        return new SimpleDoubleProperty(value);
    }

    @Override
    public <T> ObservableObjectValue<T> createReadOnlyProperty(ObjectProperty<T> property) {
        return new ReadOnlyObjectProperty<T>(property);
    }

    @Override
    public ObservableStringValue createReadOnlyProperty(StringProperty property) {
        return new ReadOnlyStringProperty(property);
    }

    @Override
    public ObservableBooleanValue createReadOnlyProperty(BooleanProperty property) {
        return new ReadOnlyBooleanProperty(property);
    }

    @Override
    public ObservableIntegerValue createReadOnlyProperty(IntegerProperty property) {
        return new ReadOnlyIntegerProperty(property);
    }

    @Override
    public ObservableDoubleValue createReadOnlyProperty(DoubleProperty property) {
        return new ReadOnlyDoubleProperty(property);
    }
}

