/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.base.node;

import com.github.franckyi.databindings.api.IntegerProperty;
import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.franckyi.guapi.api.GuapiHelper;
import com.github.franckyi.guapi.api.event.MouseButtonEvent;
import com.github.franckyi.guapi.api.node.EnumButton;
import com.github.franckyi.guapi.base.node.AbstractButton;
import java.util.function.Function;
import net.minecraft.network.chat.Component;

public abstract class AbstractEnumButton<E extends Enum<E>>
extends AbstractButton
implements EnumButton<E> {
    private final ObjectProperty<E> valueProperty = ObjectProperty.create();
    private final IntegerProperty valueIndexProperty = IntegerProperty.create();
    private final ObjectProperty<Function<E, Component>> textFactoryProperty = ObjectProperty.create(e -> GuapiHelper.text(e.name()));
    private final E[] values;
    private boolean indexUpdated;
    private boolean valueUpdated;

    protected AbstractEnumButton(Class<? extends E> enumClass) {
        this.values = (Enum[])enumClass.getEnumConstants();
        this.setupListeners();
        this.updateValue(0);
    }

    protected AbstractEnumButton(E value) {
        this.values = (Enum[])((Enum)value).getDeclaringClass().getEnumConstants();
        this.setupListeners();
        this.setValue(value);
    }

    private void setupListeners() {
        this.valueProperty.addListener(this::updateValueIndex);
        this.valueIndexProperty.addListener(this::updateValue);
        this.valueProperty.addListener(this::updateText);
        this.textFactoryProperty.addListener(this::updateText);
    }

    @Override
    public ObjectProperty<E> valueProperty() {
        return this.valueProperty;
    }

    @Override
    public IntegerProperty valueIndexProperty() {
        return this.valueIndexProperty;
    }

    @Override
    public ObjectProperty<Function<E, Component>> textFactoryProperty() {
        return this.textFactoryProperty;
    }

    @Override
    public E[] getValues() {
        return this.values;
    }

    @Override
    public void mouseClicked(MouseButtonEvent event) {
        if (event.getButton() == 0) {
            this.valueIndexProperty().incr();
        } else if (event.getButton() == 1) {
            this.valueIndexProperty().decr();
        }
    }

    private void updateValueIndex(E value) {
        this.valueUpdated = true;
        if (!this.indexUpdated) {
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] != value) continue;
                this.setValueIndex(i);
                break;
            }
        }
        this.valueUpdated = false;
    }

    private void updateValue(int valueIndex) {
        this.indexUpdated = true;
        if (valueIndex >= this.values.length) {
            this.setValueIndex(0);
        } else if (valueIndex < 0) {
            this.setValueIndex(this.values.length - 1);
        } else if (!this.valueUpdated) {
            this.setValue(this.values[valueIndex]);
        }
        this.indexUpdated = false;
    }

    private void updateText() {
        this.setLabel(this.getTextFactory().apply(this.getValue()));
    }
}

