/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.base.node;

import com.github.franckyi.databindings.api.BooleanProperty;
import com.github.franckyi.databindings.api.IntegerProperty;
import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.franckyi.databindings.api.ObservableBooleanValue;
import com.github.franckyi.databindings.api.ObservableList;
import com.github.franckyi.databindings.api.StringProperty;
import com.github.franckyi.guapi.api.GuapiHelper;
import com.github.franckyi.guapi.api.node.TextField;
import com.github.franckyi.guapi.base.node.AbstractLabeled;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;

public abstract class AbstractTextField
extends AbstractLabeled
implements TextField {
    private final StringProperty textProperty = StringProperty.create("");
    private final IntegerProperty maxLengthProperty = IntegerProperty.create(Integer.MAX_VALUE);
    private final ObjectProperty<Predicate<String>> validatorProperty = ObjectProperty.create(s -> true);
    private final BooleanProperty validationForcedProperty = BooleanProperty.create();
    private final BooleanProperty validProperty = BooleanProperty.create();
    private final ObservableBooleanValue validPropertyReadOnly = ObservableBooleanValue.readOnly(this.validProperty);
    private final ObjectProperty<TextField.TextRenderer> textRendererProperty = ObjectProperty.create();
    private final IntegerProperty cursorPositionProperty = IntegerProperty.create();
    private final IntegerProperty highlightPositionProperty = IntegerProperty.create();
    private TextField.TextFieldEventListener onTextUpdate;
    private final ObservableList<String> suggestions = ObservableList.create();
    private final BooleanProperty suggestedProperty = BooleanProperty.create();
    private final ObservableBooleanValue suggestedPropertyReadOnly = ObservableBooleanValue.readOnly(this.suggestedProperty);
    private final ObjectProperty<Component> placeholderProperty = ObjectProperty.create(GuapiHelper.EMPTY_TEXT);

    protected AbstractTextField() {
        this("");
    }

    protected AbstractTextField(String value) {
        this((Component)GuapiHelper.EMPTY_TEXT, value);
    }

    protected AbstractTextField(String label, String value) {
        this((Component)GuapiHelper.text(label), value);
    }

    protected AbstractTextField(Component label, String value) {
        super(label);
        this.setText(value);
        this.textProperty().addListener(this::updateValid);
        this.validatorProperty().addListener(this::updateValid);
        this.textProperty().addListener(this::updateCursorPos);
        this.textProperty().addListener(this::updateSuggested);
        this.getSuggestions().addListener(this::updateSuggested);
        this.focusedProperty().addListener(this::resetSelection);
    }

    @Override
    public StringProperty textProperty() {
        return this.textProperty;
    }

    @Override
    public IntegerProperty maxLengthProperty() {
        return this.maxLengthProperty;
    }

    @Override
    public ObjectProperty<Predicate<String>> validatorProperty() {
        return this.validatorProperty;
    }

    @Override
    public BooleanProperty validationForcedProperty() {
        return this.validationForcedProperty;
    }

    @Override
    public ObservableBooleanValue validProperty() {
        return this.validPropertyReadOnly;
    }

    @Override
    public ObjectProperty<TextField.TextRenderer> textRendererProperty() {
        return this.textRendererProperty;
    }

    @Override
    public IntegerProperty cursorPositionProperty() {
        return this.cursorPositionProperty;
    }

    @Override
    public IntegerProperty highlightPositionProperty() {
        return this.highlightPositionProperty;
    }

    @Override
    public void onTextUpdate(int oldCursorPos, int oldHighlightPos, String oldText, int newCursorPos, String newText) {
        if (this.onTextUpdate != null) {
            this.onTextUpdate.handle(oldCursorPos, oldHighlightPos, oldText, newCursorPos, newText);
        }
    }

    @Override
    public void setOnTextUpdate(TextField.TextFieldEventListener listener) {
        this.onTextUpdate = listener;
    }

    @Override
    public ObservableList<String> getSuggestions() {
        return this.suggestions;
    }

    @Override
    public ObservableBooleanValue suggestedProperty() {
        return this.suggestedPropertyReadOnly;
    }

    @Override
    public ObjectProperty<Component> placeholderProperty() {
        return this.placeholderProperty;
    }

    private void updateValid() {
        this.validProperty.setValue(this.getValidator().test(this.getText()));
    }

    private void updateCursorPos(String text) {
        if (text == null) {
            this.setCursorPosition(0);
            this.setHighlightPosition(0);
        } else {
            if (this.getCursorPosition() > text.length()) {
                this.setCursorPosition(this.getText().length());
            }
            if (this.getHighlightPosition() > text.length()) {
                this.setHighlightPosition(this.getText().length());
            }
        }
    }

    private void updateSuggested() {
        this.suggestedProperty.setValue(this.getSuggestions().contains(this.getText()));
    }

    private void resetSelection() {
        this.setHighlightPosition(this.getCursorPosition());
    }
}

