/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.base.client;

import com.github.franckyi.ibeeditor.base.client.mvc.model.EnchantmentListSelectionItemModel;
import com.github.franckyi.ibeeditor.base.client.mvc.model.ItemListSelectionItemModel;
import com.github.franckyi.ibeeditor.base.client.mvc.model.ListSelectionItemModel;
import com.github.franckyi.ibeeditor.base.client.mvc.model.SortedEnchantmentListSelectionItemModel;
import com.github.franckyi.ibeeditor.base.client.mvc.model.SpriteListSelectionItemModel;
import com.github.franckyi.ibeeditor.base.common.TagHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public final class ClientCache {
    private static List<String> itemSuggestions;
    private static List<ItemListSelectionItemModel> itemSelectionItems;
    private static List<String> blockSuggestions;
    private static List<ItemListSelectionItemModel> blockSelectionItems;
    private static List<String> enchantmentSuggestions;
    private static List<EnchantmentListSelectionItemModel> enchantmentSelectionItems;
    private static List<String> attributeSuggestions;
    private static List<ListSelectionItemModel> attributeSelectionItems;
    private static List<String> potionSuggestions;
    private static List<ItemListSelectionItemModel> potionSelectionItems;
    private static List<String> effectSuggestions;
    private static List<SpriteListSelectionItemModel> effectSelectionItems;

    public static List<String> getItemSuggestions() {
        return itemSuggestions == null ? (itemSuggestions = ClientCache.buildSuggestions(Registry.f_122827_)) : itemSuggestions;
    }

    public static List<ItemListSelectionItemModel> getItemSelectionItems() {
        return itemSelectionItems == null ? (itemSelectionItems = ClientCache.buildItemSelectionItems()) : itemSelectionItems;
    }

    public static List<String> getBlockSuggestions() {
        return blockSuggestions == null ? (blockSuggestions = ClientCache.buildSuggestions(Registry.f_122824_)) : blockSuggestions;
    }

    public static List<ItemListSelectionItemModel> getBlockSelectionItems() {
        return blockSelectionItems == null ? (blockSelectionItems = ClientCache.buildBlockSelectionItems()) : blockSelectionItems;
    }

    public static List<String> getEnchantmentSuggestions() {
        return enchantmentSuggestions == null ? (enchantmentSuggestions = ClientCache.buildSuggestions(Registry.f_122825_)) : enchantmentSuggestions;
    }

    public static List<SortedEnchantmentListSelectionItemModel> getSortedEnchantmentSelectionItems(ItemStack target) {
        if (enchantmentSelectionItems == null) {
            enchantmentSelectionItems = ClientCache.buildEnchantmentSelectionItems();
        }
        return enchantmentSelectionItems.stream().map(item -> new SortedEnchantmentListSelectionItemModel((EnchantmentListSelectionItemModel)item, item.getEnchantment().m_6589_(), item.getEnchantment().m_6081_(target))).sorted((o1, o2) -> {
            if (o1.isCurse()) {
                if (o2.isCurse()) {
                    return o1.getName().compareTo(o2.getName());
                }
                return 1;
            }
            if (o2.isCurse()) {
                return -1;
            }
            if (o1.canApply()) {
                if (o2.canApply()) {
                    return o1.getName().compareTo(o2.getName());
                }
                return -1;
            }
            if (o2.canApply()) {
                return 1;
            }
            return o1.getName().compareTo(o2.getName());
        }).toList();
    }

    public static List<String> getAttributeSuggestions() {
        return attributeSuggestions == null ? (attributeSuggestions = ClientCache.buildSuggestions(Registry.f_122866_)) : attributeSuggestions;
    }

    public static List<ListSelectionItemModel> getAttributeSelectionItems() {
        return attributeSelectionItems == null ? (attributeSelectionItems = ClientCache.buildAttributeSelectionItems()) : attributeSelectionItems;
    }

    public static List<String> getPotionSuggestions() {
        return potionSuggestions == null ? (potionSuggestions = ClientCache.buildSuggestions(Registry.f_122828_)) : potionSuggestions;
    }

    public static List<ItemListSelectionItemModel> getPotionSelectionItems() {
        return potionSelectionItems == null ? (potionSelectionItems = ClientCache.buildPotionSelectionItems()) : potionSelectionItems;
    }

    public static List<String> getEffectSuggestions() {
        return effectSuggestions == null ? (effectSuggestions = ClientCache.buildSuggestions(Registry.f_122823_)) : effectSuggestions;
    }

    public static List<SpriteListSelectionItemModel> getEffectSelectionItems() {
        return effectSelectionItems == null ? (effectSelectionItems = ClientCache.buildEffectSelectionItems()) : effectSelectionItems;
    }

    private static List<String> buildSuggestions(Registry<?> registry) {
        ArrayList<String> suggestions = new ArrayList<String>();
        registry.m_6579_().stream().map(e -> ((ResourceKey)e.getKey()).m_135782_().toString()).forEach(id -> {
            suggestions.add((String)id);
            if (id.startsWith("minecraft:")) {
                suggestions.add(id.substring(10));
            }
        });
        return suggestions;
    }

    private static List<ItemListSelectionItemModel> buildItemSelectionItems() {
        return Registry.f_122827_.m_6579_().stream().map(e -> new ItemListSelectionItemModel(((Item)e.getValue()).m_5524_(), ((ResourceKey)e.getKey()).m_135782_(), new ItemStack((ItemLike)e.getValue()))).toList();
    }

    private static List<ItemListSelectionItemModel> buildBlockSelectionItems() {
        return Registry.f_122824_.m_6579_().stream().map(e -> new ItemListSelectionItemModel(((Block)e.getValue()).m_7705_(), ((ResourceKey)e.getKey()).m_135782_(), new ItemStack((ItemLike)e.getValue()))).toList();
    }

    private static List<EnchantmentListSelectionItemModel> buildEnchantmentSelectionItems() {
        return Registry.f_122825_.m_6579_().stream().map(e -> new EnchantmentListSelectionItemModel(((Enchantment)e.getValue()).m_44704_(), ((ResourceKey)e.getKey()).m_135782_(), (Enchantment)e.getValue(), new ItemStack((ItemLike)ClientCache.getEnchantmentTypeItem((Enchantment)e.getValue())))).toList();
    }

    private static Item getEnchantmentTypeItem(Enchantment e) {
        EnchantmentCategory c = e.f_44672_;
        if (c == EnchantmentCategory.ARMOR || c == EnchantmentCategory.WEARABLE) {
            return Items.f_42469_;
        }
        if (c == EnchantmentCategory.ARMOR_FEET) {
            return Items.f_42475_;
        }
        if (c == EnchantmentCategory.ARMOR_LEGS) {
            return Items.f_42474_;
        }
        if (c == EnchantmentCategory.ARMOR_CHEST) {
            return Items.f_42473_;
        }
        if (c == EnchantmentCategory.ARMOR_HEAD) {
            return Items.f_42472_;
        }
        if (c == EnchantmentCategory.WEAPON) {
            return Items.f_42388_;
        }
        if (c == EnchantmentCategory.DIGGER) {
            return Items.f_42390_;
        }
        if (c == EnchantmentCategory.FISHING_ROD) {
            return Items.f_42523_;
        }
        if (c == EnchantmentCategory.TRIDENT) {
            return Items.f_42713_;
        }
        if (c == EnchantmentCategory.BOW) {
            return Items.f_42411_;
        }
        if (c == EnchantmentCategory.CROSSBOW) {
            return Items.f_42717_;
        }
        if (c == EnchantmentCategory.BREAKABLE || c == EnchantmentCategory.VANISHABLE) {
            return Items.f_42384_;
        }
        return Items.f_41852_;
    }

    private static List<ListSelectionItemModel> buildAttributeSelectionItems() {
        return Registry.f_122866_.m_6579_().stream().map(e -> new ListSelectionItemModel(((Attribute)e.getValue()).m_22087_(), ((ResourceKey)e.getKey()).m_135782_())).toList();
    }

    private static List<ItemListSelectionItemModel> buildPotionSelectionItems() {
        return Registry.f_122828_.m_6579_().stream().map(e -> new ItemListSelectionItemModel(((Potion)e.getValue()).m_43492_(Items.f_42589_.m_5524_() + ".effect."), ((ResourceKey)e.getKey()).m_135782_(), TagHelper.fromPotion(((ResourceKey)e.getKey()).m_135782_(), Integer.MIN_VALUE))).toList();
    }

    private static List<SpriteListSelectionItemModel> buildEffectSelectionItems() {
        return Registry.f_122823_.m_6579_().stream().map(e -> new SpriteListSelectionItemModel(((MobEffect)e.getValue()).m_19481_(), ((ResourceKey)e.getKey()).m_135782_(), () -> Minecraft.m_91087_().m_91306_().m_118732_((MobEffect)e.getValue()))).toList();
    }
}

