/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.base.client;

import com.github.franckyi.guapi.api.Guapi;
import com.github.franckyi.ibeeditor.base.client.ClientContext;
import com.github.franckyi.ibeeditor.base.client.ClientNetworkEmitter;
import com.github.franckyi.ibeeditor.base.client.ModScreenHandler;
import com.github.franckyi.ibeeditor.base.common.EditorType;
import com.github.franckyi.ibeeditor.base.common.ModTexts;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ClientEditorLogic {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void openWorldEditor(EditorType type) {
        LOGGER.debug("Opening world editor with type={}", (Object)type);
        if (!(ClientEditorLogic.tryOpenEntityEditor(type) || ClientEditorLogic.tryOpenBlockEditor(type) || ClientEditorLogic.tryOpenItemEditor(type))) {
            ClientEditorLogic.tryOpenSelfEditor(type);
        }
    }

    public static boolean tryOpenEntityEditor(EditorType type) {
        LOGGER.debug("Trying to open entity editor with type={}", (Object)type);
        HitResult result = Minecraft.m_91087_().f_91077_;
        if (result instanceof EntityHitResult) {
            EntityHitResult res = (EntityHitResult)result;
            Entity entity = res.m_82443_();
            if (ClientContext.isModInstalledOnServer()) {
                ClientEditorLogic.requestOpenEntityEditor(entity.m_142049_(), type);
            } else {
                ClientEditorLogic.openEntityEditor(entity.m_20240_(new CompoundTag()), entity.m_142049_(), type);
            }
            return true;
        }
        return false;
    }

    public static boolean tryOpenBlockEditor(EditorType type) {
        BlockHitResult res;
        ClientLevel level;
        LOGGER.debug("Trying to open block editor with type={}", (Object)type);
        HitResult result = Minecraft.m_91087_().f_91077_;
        if (result instanceof BlockHitResult && !(level = Minecraft.m_91087_().f_91073_).m_46859_((res = (BlockHitResult)result).m_82425_())) {
            BlockPos pos = res.m_82425_();
            if (ClientContext.isModInstalledOnServer()) {
                ClientEditorLogic.requestOpenBlockEditor(pos, type);
            } else {
                BlockState state = level.m_8055_(pos);
                BlockEntity entity = level.m_7702_(pos);
                CompoundTag tag = entity == null ? null : entity.m_187482_();
                ClientEditorLogic.openBlockEditor(pos, state, tag, type);
            }
            return true;
        }
        return false;
    }

    public static boolean tryOpenItemEditor(EditorType type) {
        LOGGER.debug("Trying to item editor with type={}", (Object)type);
        ItemStack itemStack = ClientEditorLogic.player().m_21205_();
        if (itemStack != null && !itemStack.m_41619_()) {
            if (ClientContext.isModInstalledOnServer()) {
                ClientEditorLogic.requestOpenMainHandItemEditor(type);
            } else {
                ClientEditorLogic.openMainHandItemEditor(itemStack, type);
            }
            return true;
        }
        return false;
    }

    public static void tryOpenSelfEditor(EditorType type) {
        LOGGER.debug("Trying to open self editor with type={}", (Object)type);
        if (ClientContext.isModInstalledOnServer()) {
            ClientEditorLogic.requestOpenEntityEditor(ClientEditorLogic.player().m_142049_(), type);
        } else {
            ClientEditorLogic.openEntityEditor(ClientEditorLogic.player().m_20240_(new CompoundTag()), ClientEditorLogic.player().m_142049_(), type);
        }
    }

    public static void openVault() {
    }

    private static void requestOpenMainHandItemEditor(EditorType type) {
        LOGGER.debug("Requesting main hand item editor with type={}", (Object)type);
        ClientNetworkEmitter.sendMainHandItemEditorRequest(type);
    }

    public static void openMainHandItemEditor(ItemStack itemStack, EditorType type) {
        ClientEditorLogic.openItemEditor(itemStack, type, ClientEditorLogic::updatePlayerMainHandItem, (Component)ClientEditorLogic.getDisabledTooltipCreativeMode(ModTexts.ITEM));
    }

    public static boolean tryOpenItemEditorFromScreen(EditorType type, Slot slot, boolean isCreativeInventoryScreen) {
        if (slot != null && slot.m_6657_()) {
            BlockHitResult res;
            BlockEntity blockEntity;
            if (slot.f_40218_ instanceof Inventory) {
                if (ClientContext.isModInstalledOnServer()) {
                    ClientEditorLogic.requestOpenPlayerInventoryItemEditor(type, slot.f_40219_, isCreativeInventoryScreen);
                } else {
                    ClientEditorLogic.openPlayerInventoryItemEditor(slot.m_7993_(), type, slot.f_40219_, isCreativeInventoryScreen);
                }
                return true;
            }
            HitResult hitResult = Minecraft.m_91087_().f_91077_;
            if (hitResult instanceof BlockHitResult && (blockEntity = Minecraft.m_91087_().f_91073_.m_7702_((res = (BlockHitResult)hitResult).m_82425_())) instanceof Container) {
                if (ClientContext.isModInstalledOnServer()) {
                    ClientEditorLogic.requestOpenBlockInventoryItemEditor(type, slot.f_40219_, res.m_82425_());
                } else {
                    ClientEditorLogic.openBlockInventoryItemEditor(slot.m_7993_(), type, slot.f_40219_, res.m_82425_());
                }
                return true;
            }
        }
        return false;
    }

    private static void requestOpenPlayerInventoryItemEditor(EditorType type, int slotIndex, boolean isCreativeInventoryScreen) {
        LOGGER.debug("Requesting player inventory item editor at slot index {} with type={}", (Object)slotIndex, (Object)type);
        ClientNetworkEmitter.sendPlayerInventoryItemEditorRequest(type, slotIndex, isCreativeInventoryScreen);
    }

    public static void openPlayerInventoryItemEditor(ItemStack itemStack, EditorType type, int slotId, boolean isCreativeInventoryScreen) {
        ClientEditorLogic.openItemEditor(itemStack, type, newItem -> ClientEditorLogic.updatePlayerInventoryItem(newItem, slotId, isCreativeInventoryScreen), (Component)ClientEditorLogic.getDisabledTooltipCreativeMode(ModTexts.ITEM));
    }

    private static void requestOpenBlockInventoryItemEditor(EditorType type, int slotIndex, BlockPos pos) {
        LOGGER.debug("Requesting player inventory item editor at pos {} and slot index {} with type={}", (Object)pos, (Object)slotIndex, (Object)type);
        ClientNetworkEmitter.sendBlockInventoryItemEditorRequest(type, slotIndex, pos);
    }

    public static void openBlockInventoryItemEditor(ItemStack itemStack, EditorType type, int slotId, BlockPos blockPos) {
        ClientEditorLogic.openItemEditor(itemStack, type, newItem -> ClientEditorLogic.updateBlockInventoryItem(newItem, slotId, blockPos), (Component)ClientEditorLogic.getDisabledTooltipServerMod(ModTexts.ITEM));
    }

    public static void openItemEditor(ItemStack itemStack, EditorType type, Consumer<ItemStack> action, Component disabledTooltip) {
        LOGGER.debug("Opening item editor for item {} with type={})", (Object)itemStack, (Object)type);
        switch (type) {
            case STANDARD: {
                ModScreenHandler.openItemEditorScreen(itemStack, action, disabledTooltip);
                break;
            }
            case NBT: {
                ModScreenHandler.openNBTEditorScreen(itemStack.m_41739_(new CompoundTag()), tag -> action.accept(ItemStack.m_41712_((CompoundTag)tag)), disabledTooltip);
                break;
            }
            case SNBT: {
                ModScreenHandler.openSNBTEditorScreen(itemStack.m_41739_(new CompoundTag()).toString(), snbt -> action.accept(ItemStack.m_41712_((CompoundTag)ClientEditorLogic.parseTag(snbt))), disabledTooltip);
            }
        }
    }

    public static void requestOpenBlockEditor(BlockPos pos, EditorType type) {
        LOGGER.debug("Requesting block editor at pos {} with type={}", (Object)pos, (Object)type);
        ClientNetworkEmitter.sendBlockEditorRequest(pos, type);
    }

    public static void openBlockEditor(BlockPos pos, BlockState state, CompoundTag tag, EditorType type) {
        LOGGER.debug("Opening block editor for block {} at pos {} with type={}", (Object)state, (Object)pos, (Object)type);
        switch (type) {
            case STANDARD: {
                ClientEditorLogic.player().m_5661_((Component)ModTexts.Messages.warnNotImplemented(ModTexts.BLOCK), false);
                break;
            }
            case NBT: {
                if (tag == null) {
                    ClientEditorLogic.player().m_5661_((Component)ModTexts.Messages.errorNoTargetFound(ModTexts.BLOCK), false);
                    break;
                }
                ModScreenHandler.openNBTEditorScreen(tag, newTag -> ClientEditorLogic.updateBlock(pos, state, newTag), (Component)ClientEditorLogic.getDisabledTooltipServerMod(ModTexts.BLOCK));
                break;
            }
            case SNBT: {
                if (tag == null) {
                    ClientEditorLogic.player().m_5661_((Component)ModTexts.Messages.errorNoTargetFound(ModTexts.BLOCK), false);
                    break;
                }
                ModScreenHandler.openSNBTEditorScreen(tag.toString(), snbt -> ClientEditorLogic.updateBlock(pos, state, ClientEditorLogic.parseTag(snbt)), (Component)ClientEditorLogic.getDisabledTooltipServerMod(ModTexts.BLOCK));
            }
        }
    }

    public static void requestOpenEntityEditor(int entityId, EditorType type) {
        LOGGER.debug("Requesting entity editor for entityId {} with type={}", (Object)entityId, (Object)type);
        ClientNetworkEmitter.sendEntityEditorRequest(entityId, type);
    }

    public static void openEntityEditor(CompoundTag entity, int entityId, EditorType type) {
        LOGGER.debug("Opening entity editor for entity {} with id {} and type={}", (Object)entity, (Object)entityId, (Object)type);
        switch (type) {
            case STANDARD: {
                ClientEditorLogic.player().m_5661_((Component)ModTexts.Messages.warnNotImplemented(ModTexts.ENTITY), false);
                break;
            }
            case NBT: {
                ModScreenHandler.openNBTEditorScreen(entity, tag -> ClientEditorLogic.updateEntity(entityId, tag), (Component)ClientEditorLogic.getDisabledTooltipServerMod(ModTexts.ENTITY));
                break;
            }
            case SNBT: {
                ModScreenHandler.openSNBTEditorScreen(entity.toString(), snbt -> ClientEditorLogic.updateEntity(entityId, ClientEditorLogic.parseTag(snbt)), (Component)ClientEditorLogic.getDisabledTooltipServerMod(ModTexts.ENTITY));
            }
        }
    }

    private static void updatePlayerMainHandItem(ItemStack itemStack) {
        LOGGER.debug("Updating player main hand item {}", (Object)itemStack);
        if (ClientContext.isModInstalledOnServer()) {
            ClientNetworkEmitter.sendPlayerMainHandItemUpdate(itemStack);
        } else if (ClientEditorLogic.player().m_7500_()) {
            ClientEditorLogic.player().m_21008_(InteractionHand.MAIN_HAND, itemStack);
        } else {
            ClientEditorLogic.player().m_5661_((Component)ModTexts.Messages.errorCreativeMode(ModTexts.ITEM), false);
        }
        Guapi.getScreenHandler().hideScene();
    }

    private static void updatePlayerInventoryItem(ItemStack itemStack, int slotId, boolean isCreativeInventoryScreen) {
        LOGGER.debug("Updating player inventory item {} in slot {}", (Object)itemStack, (Object)slotId);
        if (ClientContext.isModInstalledOnServer()) {
            ClientNetworkEmitter.sendPlayerInventoryItemUpdate(itemStack, slotId);
        } else if (ClientEditorLogic.player().m_7500_()) {
            if (isCreativeInventoryScreen) {
                ClientEditorLogic.player().m_150109_().m_6836_(slotId, itemStack);
            } else {
                Minecraft.m_91087_().f_91072_.m_105241_(itemStack, slotId);
            }
        } else {
            ClientEditorLogic.player().m_5661_((Component)ModTexts.Messages.errorServerMod(ModTexts.ITEM), false);
        }
        Guapi.getScreenHandler().hideScene();
    }

    private static void updateBlockInventoryItem(ItemStack itemStack, int slotId, BlockPos blockPos) {
        LOGGER.debug("Updating block inventory item {} at pos {} and in slot {}", (Object)itemStack, (Object)blockPos, (Object)slotId);
        if (ClientContext.isModInstalledOnServer()) {
            ClientNetworkEmitter.sendBlockInventoryItemUpdate(itemStack, slotId, blockPos);
        } else {
            ClientEditorLogic.player().m_5661_((Component)ModTexts.Messages.errorServerMod(ModTexts.ITEM), false);
        }
        Guapi.getScreenHandler().hideScene();
    }

    private static void updateBlock(BlockPos pos, BlockState state, CompoundTag tag) {
        LOGGER.debug("Updating block {} at pos {}", (Object)state, (Object)pos);
        if (ClientContext.isModInstalledOnServer()) {
            ClientNetworkEmitter.sendBlockUpdate(pos, state, tag);
        } else {
            ClientEditorLogic.player().m_5661_((Component)ModTexts.Messages.errorServerMod(ModTexts.BLOCK), false);
        }
        Guapi.getScreenHandler().hideScene();
    }

    private static void updateEntity(int entityId, CompoundTag tag) {
        LOGGER.debug("Updating entity {} with id {}", (Object)tag.toString(), (Object)entityId);
        if (ClientContext.isModInstalledOnServer()) {
            ClientNetworkEmitter.sendEntityUpdate(entityId, tag);
        } else {
            ClientEditorLogic.player().m_5661_((Component)ModTexts.Messages.errorServerMod(ModTexts.ENTITY), false);
        }
        Guapi.getScreenHandler().hideScene();
    }

    private static CompoundTag parseTag(String snbt) {
        try {
            return TagParser.m_129359_((String)snbt);
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static LocalPlayer player() {
        return Minecraft.m_91087_().f_91074_;
    }

    private static MutableComponent getDisabledTooltipServerMod(MutableComponent arg) {
        return ClientContext.isModInstalledOnServer() ? null : ModTexts.serverMod(arg);
    }

    private static MutableComponent getDisabledTooltipCreativeMode(MutableComponent arg) {
        return ClientContext.isModInstalledOnServer() || ClientEditorLogic.player().m_7500_() ? null : ModTexts.creativeMode(arg);
    }
}

