/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.base.client;

import com.github.franckyi.ibeeditor.PlatformUtilClient;
import com.github.franckyi.ibeeditor.base.client.ClientEditorLogic;
import com.github.franckyi.ibeeditor.base.client.KeyBindings;
import com.github.franckyi.ibeeditor.base.common.EditorType;
import com.github.franckyi.ibeeditor.base.common.ModTexts;
import com.github.franckyi.ibeeditor.mixin.AbstractContainerScreenMixin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ClientEventHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void onKeyInput() {
        try {
            if (KeyBindings.editorKey.m_90859_()) {
                ClientEditorLogic.openWorldEditor(EditorType.STANDARD);
            } else if (KeyBindings.nbtEditorKey.m_90859_()) {
                ClientEditorLogic.openWorldEditor(EditorType.NBT);
            } else if (KeyBindings.snbtEditorKey.m_90859_()) {
                ClientEditorLogic.openWorldEditor(EditorType.SNBT);
            }
        }
        catch (Exception e) {
            Minecraft.m_91087_().f_91074_.m_5661_((Component)ModTexts.Messages.ERROR_GENERIC, false);
            LOGGER.error("Error while handling ingame key input for IBE Editor mod", (Throwable)e);
        }
    }

    public static boolean onScreenEvent(AbstractContainerScreen<?> screen, int keyCode) {
        try {
            EditorType type = null;
            if (keyCode == PlatformUtilClient.getKeyCode(KeyBindings.editorKey)) {
                type = EditorType.STANDARD;
            } else if (keyCode == PlatformUtilClient.getKeyCode(KeyBindings.nbtEditorKey)) {
                type = EditorType.NBT;
            } else if (keyCode == PlatformUtilClient.getKeyCode(KeyBindings.snbtEditorKey)) {
                type = EditorType.SNBT;
            }
            if (type != null) {
                return ClientEditorLogic.tryOpenItemEditorFromScreen(type, ((AbstractContainerScreenMixin)screen).getHoveredSlot(), screen instanceof CreativeModeInventoryScreen);
            }
        }
        catch (Exception e) {
            Minecraft.m_91087_().f_91074_.m_5661_((Component)ModTexts.Messages.ERROR_GENERIC, false);
            LOGGER.error("Error while handling screen key input for IBE Editor mod", (Throwable)e);
        }
        return false;
    }
}

