/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.base.client.mvc.controller;

import com.github.franckyi.guapi.api.Guapi;
import com.github.franckyi.guapi.api.mvc.AbstractController;
import com.github.franckyi.ibeeditor.base.client.mvc.model.NBTEditorModel;
import com.github.franckyi.ibeeditor.base.client.mvc.model.NBTTagModel;
import com.github.franckyi.ibeeditor.base.client.mvc.view.NBTEditorView;
import com.github.franckyi.ibeeditor.base.common.TagHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.nbt.Tag;

public class NBTEditorController
extends AbstractController<NBTEditorModel, NBTEditorView> {
    public NBTEditorController(NBTEditorModel model, NBTEditorView view) {
        super(model, view);
    }

    @Override
    public void bind() {
        ((NBTEditorView)this.view).getTagTree().rootItemProperty().bind(((NBTEditorModel)this.model).rootTagProperty());
        if (((NBTEditorModel)this.model).canSave()) {
            ((NBTEditorView)this.view).getDoneButton().disableProperty().bind(((NBTEditorModel)this.model).rootTagProperty().bindMapToBoolean(NBTTagModel::validProperty).not());
            ((NBTEditorView)this.view).getDoneButton().onAction(event -> ((NBTEditorModel)this.model).apply());
        } else {
            ((NBTEditorView)this.view).getDoneButton().setDisable(true);
            ((NBTEditorView)this.view).getDoneButton().getTooltip().add(((NBTEditorModel)this.model).getDisabledTooltip());
        }
        ((NBTEditorView)this.view).getCancelButton().onAction(event -> Guapi.getScreenHandler().hideScene());
        ((NBTEditorView)this.view).getTagTree().focusedElementProperty().addListener(this::updateEnabledButtons);
        ((NBTEditorView)this.view).setOnButtonClick(this::onButtonClick);
    }

    private void onButtonClick(NBTEditorView.ButtonType target) {
        NBTTagModel tag = (NBTTagModel)((NBTEditorView)this.view).getTagTree().getFocusedElement();
        NBTTagModel parent = (NBTTagModel)tag.getParent();
        switch (target) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BYTE_ARRAY: 
            case STRING: 
            case LIST: 
            case COMPOUND: 
            case INT_ARRAY: 
            case LONG_ARRAY: {
                this.addChildTag(tag, TagHelper.createEmptyTag(target.getType()));
                break;
            }
            case MOVE_UP: {
                int index0 = parent.getChildren().indexOf(tag);
                Collections.swap(parent.getChildren(), index0, index0 - 1);
                this.updateEnabledButtons(tag);
                break;
            }
            case MOVE_DOWN: {
                int index1 = parent.getChildren().indexOf(tag);
                Collections.swap(parent.getChildren(), index1, index1 + 1);
                this.updateEnabledButtons(tag);
                break;
            }
            case ADD: {
                switch (tag.getTagType()) {
                    case 7: {
                        this.addChildTag(tag, (byte)1, "0");
                        break;
                    }
                    case 11: {
                        this.addChildTag(tag, (byte)3, "0");
                        break;
                    }
                    case 12: {
                        this.addChildTag(tag, (byte)4, "0");
                        break;
                    }
                    case 9: {
                        if (tag.getChildren().isEmpty()) break;
                        this.addChildTag(tag, TagHelper.createEmptyTag(((NBTTagModel)tag.getChildren().get(0)).getTagType()));
                    }
                }
                break;
            }
            case CUT: {
                ((NBTEditorModel)this.model).setClipboardTag(tag);
            }
            case DELETE: {
                parent.getChildren().remove(tag);
                ((NBTEditorView)this.view).getTagTree().setFocusedElement(null);
                break;
            }
            case COPY: {
                ((NBTEditorModel)this.model).setClipboardTag(tag.createClipboardTag());
                this.updateEnabledButtons(tag);
                break;
            }
            case PASTE: {
                NBTTagModel clipboardTag = ((NBTEditorModel)this.model).getClipboardTag();
                if (clipboardTag.canBuild()) {
                    this.addChildTag(tag, clipboardTag.build(), clipboardTag.getName());
                    break;
                }
                this.addChildTag(tag, clipboardTag.getTagType(), clipboardTag.getValue());
            }
        }
    }

    private void updateEnabledButtons(NBTTagModel newVal) {
        ((NBTEditorView)this.view).getAddTagButton().setActive(false);
        ArrayList<NBTEditorView.ButtonType> buttons = new ArrayList<NBTEditorView.ButtonType>();
        NBTTagModel clipboardTag = ((NBTEditorModel)this.model).getClipboardTag();
        if (newVal != null) {
            switch (newVal.getTagType()) {
                case 10: {
                    buttons.add(NBTEditorView.ButtonType.ADD);
                    if (clipboardTag == null || !clipboardTag.canBuild()) break;
                    buttons.add(NBTEditorView.ButtonType.PASTE);
                    break;
                }
                case 7: {
                    if (clipboardTag != null && !clipboardTag.canBuild() && clipboardTag.getTagType() == 1) {
                        buttons.add(NBTEditorView.ButtonType.PASTE);
                    }
                    buttons.add(NBTEditorView.ButtonType.ADD);
                    break;
                }
                case 11: {
                    if (clipboardTag != null && !clipboardTag.canBuild() && clipboardTag.getTagType() == 3) {
                        buttons.add(NBTEditorView.ButtonType.PASTE);
                    }
                    buttons.add(NBTEditorView.ButtonType.ADD);
                    break;
                }
                case 12: {
                    if (clipboardTag != null && !clipboardTag.canBuild() && clipboardTag.getTagType() == 4) {
                        buttons.add(NBTEditorView.ButtonType.PASTE);
                    }
                    buttons.add(NBTEditorView.ButtonType.ADD);
                    break;
                }
                case 9: {
                    if (newVal.getChildren().isEmpty()) {
                        buttons.add(NBTEditorView.ButtonType.ADD);
                        if (clipboardTag == null || !clipboardTag.canBuild()) break;
                        buttons.add(NBTEditorView.ButtonType.PASTE);
                        break;
                    }
                    buttons.add(NBTEditorView.ButtonType.ADD);
                    if (clipboardTag == null || !clipboardTag.canBuild() || clipboardTag.getTagType() != ((NBTTagModel)newVal.getChildren().get(0)).getTagType()) break;
                    buttons.add(NBTEditorView.ButtonType.PASTE);
                }
            }
            if (newVal.getParent() != null) {
                NBTTagModel parent = (NBTTagModel)newVal.getParent();
                if (parent.getChildren().indexOf(newVal) != 0) {
                    buttons.add(NBTEditorView.ButtonType.MOVE_UP);
                }
                if (parent.getChildren().indexOf(newVal) != parent.getChildren().size() - 1) {
                    buttons.add(NBTEditorView.ButtonType.MOVE_DOWN);
                }
                buttons.add(NBTEditorView.ButtonType.DELETE);
                buttons.add(NBTEditorView.ButtonType.CUT);
            }
            buttons.add(NBTEditorView.ButtonType.COPY);
        }
        ((NBTEditorView)this.view).getEnabledButtons().setAll((Collection<NBTEditorView.ButtonType>)buttons);
    }

    private void addChildTag(NBTTagModel parent, Tag newTag) {
        this.addChildTag(parent, newTag, "");
    }

    private void addChildTag(NBTTagModel parent, Tag newTag, String name) {
        this.addChildTag(parent, new NBTTagModel(newTag, parent, parent.getTagType() != 9 ? name : null, null));
    }

    private void addChildTag(NBTTagModel parent, byte target, String value) {
        this.addChildTag(parent, new NBTTagModel(target, parent, value));
    }

    private void addChildTag(NBTTagModel parent, NBTTagModel tag) {
        parent.getChildren().add(tag);
        parent.setExpanded(true);
        ((NBTEditorView)this.view).getTagTree().setScrollTo(tag);
        ((NBTEditorView)this.view).getTagTree().setFocusedElement(tag);
    }
}

