/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.base.client.mvc.model;

import com.github.franckyi.databindings.api.BooleanProperty;
import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.franckyi.databindings.api.ObservableList;
import com.github.franckyi.guapi.api.mvc.Model;
import com.github.franckyi.ibeeditor.base.client.mvc.model.CategoryModel;
import com.github.franckyi.ibeeditor.base.client.util.texteditor.TextEditorActionHandler;

public abstract class ListEditorModel<C extends CategoryModel>
implements Model {
    protected final BooleanProperty validProperty = BooleanProperty.create(true);
    protected final ObservableList<C> categories = ObservableList.create();
    protected final ObjectProperty<CategoryModel> selectedCategory = ObjectProperty.create();
    protected final ObjectProperty<TextEditorActionHandler> activeTextEditorProperty = ObjectProperty.create();

    @Override
    public void initalize() {
        this.setupCategories();
        this.selectedCategoryProperty().addListener((oldVal, newVal) -> {
            if (oldVal != null) {
                oldVal.setSelected(false);
            }
            if (newVal != null) {
                newVal.setSelected(true);
            }
        });
        if (this.getCategories().size() > 0) {
            this.setSelectedCategory((CategoryModel)this.getCategories().get(0));
            this.updateValidity();
        }
        this.getCategories().addListener(this::updateValidity);
    }

    protected abstract void setupCategories();

    public abstract void apply();

    public ObservableList<C> getCategories() {
        return this.categories;
    }

    public CategoryModel getSelectedCategory() {
        return (CategoryModel)this.selectedCategoryProperty().getValue();
    }

    public ObjectProperty<CategoryModel> selectedCategoryProperty() {
        return this.selectedCategory;
    }

    public void setSelectedCategory(CategoryModel value) {
        this.selectedCategoryProperty().setValue(value);
    }

    public boolean isValid() {
        return this.validProperty().getValue();
    }

    public BooleanProperty validProperty() {
        return this.validProperty;
    }

    public void setValid(boolean value) {
        this.validProperty().setValue(value);
    }

    public TextEditorActionHandler getActiveTextEditor() {
        return (TextEditorActionHandler)this.activeTextEditorProperty().getValue();
    }

    public ObjectProperty<TextEditorActionHandler> activeTextEditorProperty() {
        return this.activeTextEditorProperty;
    }

    public void setActiveTextEditor(TextEditorActionHandler value) {
        this.activeTextEditorProperty().setValue(value);
    }

    public void updateValidity() {
        this.setValid(this.getCategories().stream().allMatch(CategoryModel::isValid));
    }
}

