/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.base.client.mvc.model;

import com.github.franckyi.databindings.api.StringProperty;
import com.github.franckyi.ibeeditor.base.client.mvc.model.CategoryModel;
import com.github.franckyi.ibeeditor.base.client.mvc.model.ListEditorModel;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public abstract class StandardEditorModel<T, C extends CategoryModel>
extends ListEditorModel<C> {
    private final T target;
    private final Consumer<T> action;
    private final Component disabledTooltip;
    private final MutableComponent title;
    private final StringProperty currentCustomColorProperty;

    protected StandardEditorModel(T target, Consumer<T> action, Component disabledTooltip, MutableComponent title) {
        this.target = target;
        this.action = action;
        this.disabledTooltip = disabledTooltip;
        this.title = title;
        this.currentCustomColorProperty = StringProperty.create("#ffffff");
    }

    public T getTarget() {
        return this.target;
    }

    public Consumer<T> getAction() {
        return this.action;
    }

    public Component getDisabledTooltip() {
        return this.disabledTooltip;
    }

    public boolean isDisabled() {
        return this.getDisabledTooltip() != null;
    }

    public MutableComponent getTitle() {
        return this.title;
    }

    public String getCurrentCustomColor() {
        return (String)this.currentCustomColorProperty().getValue();
    }

    public StringProperty currentCustomColorProperty() {
        return this.currentCustomColorProperty;
    }

    public void setCurrentCustomColor(String value) {
        this.currentCustomColorProperty().setValue(value);
    }

    @Override
    public void apply() {
        this.getAction().accept(this.applyChanges());
    }

    protected abstract T applyChanges();
}

