/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.base.client.mvc.model.category;

import com.github.franckyi.ibeeditor.base.client.mvc.model.ItemEditorModel;
import com.github.franckyi.ibeeditor.base.client.mvc.model.category.ItemCategoryModel;
import com.github.franckyi.ibeeditor.base.client.mvc.model.entry.EntryModel;
import com.github.franckyi.ibeeditor.base.client.mvc.model.entry.PotionEffectEntryModel;
import com.github.franckyi.ibeeditor.base.client.mvc.model.entry.PotionSelectionEntryModel;
import com.github.franckyi.ibeeditor.base.common.ModTexts;
import java.util.Collection;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ItemPotionEffectsCategoryModel
extends ItemCategoryModel {
    private ListTag potionEffectList;

    public ItemPotionEffectsCategoryModel(ItemEditorModel editor) {
        super((Component)ModTexts.POTION_EFFECTS, editor);
    }

    @Override
    protected void setupEntries() {
        this.getEntries().add(new PotionSelectionEntryModel(this, ModTexts.DEFAULT_POTION, this.getBaseTag().m_128461_("Potion"), this.getCustomPotionColor(), p -> this.getNewTag().m_128359_("Potion", p), this::setCustomPotionColor));
        this.getEntries().addAll((Collection<EntryModel>)this.getBaseTag().m_128437_("CustomPotionEffects", 10).stream().map(CompoundTag.class::cast).map(this::createPotionEffectEntry).toList());
    }

    @Override
    public int getEntryListStart() {
        return 1;
    }

    @Override
    public EntryModel createListEntry() {
        return this.createPotionEffectEntry(null);
    }

    @Override
    public int getEntryHeight() {
        return 50;
    }

    @Override
    protected MutableComponent getAddListEntryButtonTooltip() {
        return ModTexts.EFFECT;
    }

    private int getCustomPotionColor() {
        return this.getBaseTag().m_128425_("CustomPotionColor", 3) ? this.getBaseTag().m_128451_("CustomPotionColor") : Integer.MIN_VALUE;
    }

    private void setCustomPotionColor(int color) {
        if (color != Integer.MIN_VALUE) {
            this.getNewTag().m_128405_("CustomPotionColor", color);
        } else {
            this.getNewTag().m_128473_("CustomPotionColor");
        }
    }

    private EntryModel createPotionEffectEntry(CompoundTag tag) {
        if (tag != null) {
            int id = tag.m_128451_("Id");
            int amplifier = tag.m_128451_("Amplifier");
            int duration = tag.m_128425_("Duration", 3) ? tag.m_128451_("Duration") : 1;
            boolean ambient = tag.m_128471_("Ambient");
            boolean showParticles = !tag.m_128425_("ShowParticles", 1) || tag.m_128471_("ShowParticles");
            boolean showIcon = tag.m_128471_("ShowIcon");
            return new PotionEffectEntryModel(this, id, amplifier, duration, ambient, showParticles, showIcon, this::addPotionEffect);
        }
        return new PotionEffectEntryModel(this, 1, 0, 1, false, true, true, this::addPotionEffect);
    }

    @Override
    public void apply(CompoundTag nbt) {
        this.potionEffectList = new ListTag();
        super.apply(nbt);
        if (!this.potionEffectList.isEmpty()) {
            this.getNewTag().m_128365_("CustomPotionEffects", (Tag)this.potionEffectList);
        } else {
            this.getNewTag().m_128473_("CustomPotionEffects");
        }
    }

    private void addPotionEffect(int id, int amplifier, int duration, boolean ambient, boolean showParticles, boolean showIcon) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("Id", id);
        tag.m_128405_("Amplifier", amplifier);
        tag.m_128405_("Duration", duration);
        tag.m_128379_("Ambient", ambient);
        tag.m_128379_("ShowParticles", showParticles);
        tag.m_128379_("ShowIcon", showIcon);
        this.potionEffectList.add((Object)tag);
    }
}

