/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.base.client.mvc.model.entry;

import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.franckyi.databindings.api.ObservableBooleanValue;
import com.github.franckyi.ibeeditor.base.client.mvc.model.CategoryModel;
import com.github.franckyi.ibeeditor.base.client.mvc.model.entry.LabeledEntryModel;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.network.chat.MutableComponent;

public abstract class ValueEntryModel<T>
extends LabeledEntryModel {
    protected T defaultValue;
    private final ObjectProperty<T> valueProperty;
    private final ObservableBooleanValue valueChangedProperty;
    protected final Consumer<T> action;

    public ValueEntryModel(CategoryModel category, MutableComponent label, T value, Consumer<T> action) {
        super(category, label);
        this.defaultValue = value;
        this.valueProperty = ObjectProperty.create(value);
        this.valueChangedProperty = this.valueProperty.mapToBoolean(v -> !Objects.equals(v, this.defaultValue));
        this.action = action;
    }

    @Override
    public void reset() {
        this.valueProperty.setValue(this.defaultValue);
    }

    public T getValue() {
        return this.valueProperty().getValue();
    }

    public ObjectProperty<T> valueProperty() {
        return this.valueProperty;
    }

    public void setValue(T value) {
        this.valueProperty().setValue(value);
    }

    public ObservableBooleanValue valueChangedProperty() {
        return this.valueChangedProperty;
    }

    @Override
    public void apply() {
        this.action.accept(this.getValue());
        this.defaultValue = this.getValue();
    }
}

