/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.base.client.mvc.view;

import com.github.franckyi.guapi.api.GuapiHelper;
import com.github.franckyi.guapi.api.mvc.View;
import com.github.franckyi.guapi.api.node.Button;
import com.github.franckyi.guapi.api.node.Label;
import com.github.franckyi.guapi.api.node.Node;
import com.github.franckyi.guapi.api.node.TexturedButton;
import com.github.franckyi.guapi.api.node.VBox;
import com.github.franckyi.guapi.api.node.builder.HBoxBuilder;
import com.github.franckyi.guapi.api.node.builder.LabelBuilder;
import com.github.franckyi.guapi.api.node.builder.TexturedButtonBuilder;
import com.github.franckyi.guapi.api.node.builder.VBoxBuilder;
import com.github.franckyi.ibeeditor.base.client.ModScreenHandler;
import com.github.franckyi.ibeeditor.base.client.ModTextures;
import com.github.franckyi.ibeeditor.base.client.util.ScreenScalingManager;
import com.github.franckyi.ibeeditor.base.common.ModTexts;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public abstract class EditorView
implements View {
    private VBox root;
    private Label headerLabel;
    private TexturedButton zoomResetButton;
    private TexturedButton zoomOutButton;
    private TexturedButton zoomInButton;
    private Button cancelButton;
    private Button doneButton;
    private Label zoomLabel;

    @Override
    public void build() {
        this.root = GuapiHelper.vBox(root -> {
            ((VBoxBuilder)((VBoxBuilder)((VBoxBuilder)root.spacing(5)).align(GuapiHelper.CENTER)).padding(5)).fillWidth();
            root.add(this.createHeader());
            root.add(this.createMain(), 1);
            root.add(this.createFooter());
        });
        ScreenScalingManager.get().scaleProperty().addListener(this::onZoomUpdated);
        this.zoomResetButton.disableProperty().bind(ScreenScalingManager.get().canScaleBeResetProperty().not());
        this.onZoomUpdated();
    }

    protected Node createHeader() {
        return GuapiHelper.hBox(header -> {
            header.add((Node)GuapiHelper.hBox().prefWidth(16));
            this.headerLabel = (Label)((LabelBuilder)GuapiHelper.label((Component)this.getHeaderLabelText()).textAlign(GuapiHelper.CENTER)).prefHeight(20);
            header.add(this.headerLabel, 1);
            header.add((Node)this.createButton(ModTextures.SETTINGS, ModTexts.SETTINGS).action(ModScreenHandler::openSettingsScreen));
            header.align(GuapiHelper.CENTER);
        });
    }

    protected MutableComponent getHeaderLabelText() {
        return GuapiHelper.EMPTY_TEXT;
    }

    protected Node createMain() {
        return GuapiHelper.vBox(main -> {
            main.add(this.createButtonBar());
            main.add(this.createEditor(), 1);
            ((VBoxBuilder)main.spacing(2)).fillWidth();
        });
    }

    protected Node createButtonBar() {
        return GuapiHelper.hBox(buttons -> {
            this.zoomResetButton = (TexturedButton)this.createButton(ModTextures.ZOOM_RESET, ModTexts.ZOOM_RESET).action(ScreenScalingManager.get()::restoreScale);
            buttons.add(this.zoomResetButton);
            this.zoomOutButton = (TexturedButton)this.createButton(ModTextures.ZOOM_OUT, ModTexts.ZOOM_OUT).action(ScreenScalingManager.get()::scaleDown);
            buttons.add(this.zoomOutButton);
            this.zoomLabel = (Label)((LabelBuilder)((LabelBuilder)GuapiHelper.label().prefWidth(25)).textAlign(GuapiHelper.CENTER)).padding(0, 3);
            buttons.add(this.zoomLabel);
            this.zoomInButton = (TexturedButton)this.createButton(ModTextures.ZOOM_IN, ModTexts.ZOOM_IN).action(ScreenScalingManager.get()::scaleUp);
            buttons.add(this.zoomInButton);
            ((HBoxBuilder)((HBoxBuilder)((HBoxBuilder)buttons.fillHeight()).spacing(2)).prefHeight(16)).align(GuapiHelper.CENTER_RIGHT);
        });
    }

    protected abstract Node createEditor();

    protected Node createFooter() {
        return GuapiHelper.hBox(footer -> {
            ((HBoxBuilder)footer.spacing(20)).align(GuapiHelper.CENTER);
            this.cancelButton = (Button)GuapiHelper.button((Component)ModTexts.CANCEL).prefWidth(90);
            footer.add(this.cancelButton);
            this.doneButton = (Button)GuapiHelper.button((Component)ModTexts.DONE).prefWidth(90);
            footer.add(this.doneButton);
        });
    }

    protected TexturedButtonBuilder createButton(ResourceLocation id, String tooltipText) {
        return this.createButton(id, (MutableComponent)GuapiHelper.translated(tooltipText));
    }

    protected TexturedButtonBuilder createButton(ResourceLocation id, MutableComponent tooltipText) {
        return (TexturedButtonBuilder)GuapiHelper.texturedButton(id, 16, 16, false).tooltip(new Component[]{tooltipText});
    }

    protected void onZoomUpdated() {
        this.zoomOutButton.setDisable(!ScreenScalingManager.get().canScaleDown());
        this.zoomLabel.setLabel((Component)GuapiHelper.text(ScreenScalingManager.get().getScale() == 0 ? "Auto" : Integer.toString(ScreenScalingManager.get().getScale())));
        this.zoomInButton.setDisable(!ScreenScalingManager.get().canScaleUp());
    }

    @Override
    public VBox getRoot() {
        return this.root;
    }

    public Label getHeaderLabel() {
        return this.headerLabel;
    }

    public Button getCancelButton() {
        return this.cancelButton;
    }

    public Button getDoneButton() {
        return this.doneButton;
    }
}

