/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.base.common;

import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public final class TagHelper {
    public static final byte BYTE_ID = 1;
    public static final byte SHORT_ID = 2;
    public static final byte INT_ID = 3;
    public static final byte LONG_ID = 4;
    public static final byte FLOAT_ID = 5;
    public static final byte DOUBLE_ID = 6;
    public static final byte BYTE_ARRAY_ID = 7;
    public static final byte STRING_ID = 8;
    public static final byte LIST_ID = 9;
    public static final byte COMPOUND_ID = 10;
    public static final byte INT_ARRAY_ID = 11;
    public static final byte LONG_ARRAY_ID = 12;

    private TagHelper() {
    }

    public static Tag createEmptyTag(byte type) {
        return switch (type) {
            case 1 -> ByteTag.f_128256_;
            case 2 -> ShortTag.m_129258_((short)0);
            case 3 -> IntTag.m_128679_((int)0);
            case 4 -> LongTag.m_128882_((long)0L);
            case 5 -> FloatTag.f_128559_;
            case 6 -> DoubleTag.f_128493_;
            case 7 -> new ByteArrayTag(new byte[0]);
            case 8 -> StringTag.m_129297_((String)"");
            case 9 -> new ListTag();
            case 10 -> new CompoundTag();
            case 11 -> new IntArrayTag(new int[0]);
            case 12 -> new LongArrayTag(new long[0]);
            default -> null;
        };
    }

    public static ItemStack fromPotion(ResourceLocation id, int color) {
        CompoundTag data = new CompoundTag();
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Potion", id == null ? "minecraft:empty" : id.toString());
        if (color != Integer.MIN_VALUE) {
            tag.m_128405_("CustomPotionColor", color);
        }
        data.m_128359_("id", "minecraft:potion");
        data.m_128405_("Count", 1);
        data.m_128365_("tag", (Tag)tag);
        return ItemStack.m_41712_((CompoundTag)data);
    }

    public static ItemStack fromArmor(CompoundTag data, int color) {
        if (color == Integer.MIN_VALUE) {
            data.m_128469_("tag").m_128473_("display");
        } else {
            CompoundTag tag;
            if (!data.m_128425_("tag", 10)) {
                data.m_128365_("tag", (Tag)new CompoundTag());
            }
            if (!(tag = data.m_128469_("tag")).m_128425_("display", 10)) {
                tag.m_128365_("display", (Tag)new CompoundTag());
            }
            CompoundTag display = tag.m_128469_("display");
            display.m_128405_("color", color);
        }
        return ItemStack.m_41712_((CompoundTag)data);
    }
}

