/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.base.server;

import com.github.franckyi.ibeeditor.base.common.CommonConfiguration;
import com.github.franckyi.ibeeditor.base.common.EditorType;
import com.github.franckyi.ibeeditor.base.common.ModTexts;
import com.github.franckyi.ibeeditor.base.server.ServerNetworkEmitter;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ServerEditorLogic {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void updatePlayerMainHandItem(ServerPlayer player, ItemStack itemStack) {
        if (ServerEditorLogic.checkPermission(player)) {
            return;
        }
        LOGGER.debug("Updating {}'s main hand item to {}", (Object)player.m_36316_().getName(), (Object)itemStack);
        LOGGER.debug((Object)itemStack.m_41739_(new CompoundTag()));
        player.m_21008_(InteractionHand.MAIN_HAND, itemStack);
        player.m_5661_((Component)ModTexts.Messages.successUpdate(ModTexts.ITEM), false);
    }

    public static void updatePlayerInventoryItem(ServerPlayer player, ItemStack itemStack, int slotId) {
        if (ServerEditorLogic.checkPermission(player)) {
            return;
        }
        LOGGER.debug("Updating {}'s inventory item at slot {} to {}", (Object)player.m_36316_().getName(), (Object)slotId, (Object)itemStack);
        LOGGER.debug((Object)itemStack.m_41739_(new CompoundTag()));
        player.m_150109_().m_6836_(slotId, itemStack);
        player.m_5661_((Component)ModTexts.Messages.successUpdate(ModTexts.ITEM), false);
    }

    public static void updateBlockInventoryItem(ServerPlayer player, ItemStack itemStack, int slotId, BlockPos blockPos) {
        if (ServerEditorLogic.checkPermission(player)) {
            return;
        }
        LOGGER.debug("Updating block inventory item at pos {} and slot {} to {}", (Object)blockPos, (Object)slotId, (Object)itemStack);
        LOGGER.debug((Object)itemStack.m_41739_(new CompoundTag()));
        ServerLevel level = player.m_183503_();
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof Container) {
            ((Container)blockEntity).m_6836_(slotId, itemStack);
            player.m_5661_((Component)ModTexts.Messages.successUpdate(ModTexts.ITEM), false);
        } else {
            player.m_5661_((Component)ModTexts.Messages.errorNoTargetFound(ModTexts.ITEM), false);
        }
    }

    public static void updateBlock(ServerPlayer player, BlockPos pos, BlockState state, CompoundTag tag) {
        if (ServerEditorLogic.checkPermission(player)) {
            return;
        }
        LOGGER.debug("Updating block {} at pos {}", (Object)state, (Object)pos);
        LOGGER.debug((Object)tag);
        ServerLevel level = player.m_183503_();
        level.m_46597_(pos, state);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity != null) {
            blockEntity.m_142466_(tag);
        }
        player.m_5661_((Component)ModTexts.Messages.successUpdate(ModTexts.BLOCK), false);
    }

    public static void updateEntity(ServerPlayer player, CompoundTag tag, int entityId) {
        if (ServerEditorLogic.checkPermission(player)) {
            return;
        }
        LOGGER.debug("Updating entity {} with id {}", (Object)tag, (Object)entityId);
        LOGGER.debug((Object)tag);
        Entity entity = player.m_183503_().m_6815_(entityId);
        if (entity != null) {
            entity.m_20258_(tag);
            player.m_5661_((Component)ModTexts.Messages.successUpdate(ModTexts.ENTITY), false);
        } else {
            player.m_5661_((Component)ModTexts.Messages.errorNoTargetFound(ModTexts.ENTITY), false);
        }
    }

    public static void processMainHandItemEditorRequest(ServerPlayer player, EditorType editorType) {
        if (ServerEditorLogic.checkPermission(player)) {
            return;
        }
        ServerNetworkEmitter.sendMainHandItemEditorResponse(player, editorType, player.m_21205_());
    }

    public static void processPlayerInventoryItemEditorRequest(ServerPlayer player, EditorType editorType, int slotIndex, boolean isCreativeInventoryScreen) {
        if (ServerEditorLogic.checkPermission(player)) {
            return;
        }
        ServerNetworkEmitter.sendPlayerInventoryItemEditorResponse(player, editorType, slotIndex, isCreativeInventoryScreen, player.m_150109_().m_8020_(slotIndex));
    }

    public static void processBlockInventoryItemEditorRequest(ServerPlayer player, EditorType editorType, int slotIndex, BlockPos pos) {
        if (ServerEditorLogic.checkPermission(player)) {
            return;
        }
        BlockEntity blockEntity = player.m_183503_().m_7702_(pos);
        if (blockEntity instanceof Container) {
            ServerNetworkEmitter.sendBlockInventoryItemEditorResponse(player, editorType, slotIndex, pos, ((Container)blockEntity).m_8020_(slotIndex));
        } else {
            player.m_5661_((Component)ModTexts.Messages.errorNoTargetFound(ModTexts.ITEM), false);
        }
    }

    public static void processBlockEditorRequest(ServerPlayer player, EditorType editorType, BlockPos pos) {
        CompoundTag tag;
        if (ServerEditorLogic.checkPermission(player)) {
            return;
        }
        ServerLevel level = player.m_183503_();
        BlockState state = level.m_8055_(pos);
        BlockEntity blockEntity = level.m_7702_(pos);
        CompoundTag compoundTag = tag = blockEntity == null ? null : blockEntity.m_187482_();
        if (tag != null || !editorType.isNBT() && state != null) {
            ServerNetworkEmitter.sendBlockEditorResponse(player, editorType, pos, state, tag);
        } else {
            player.m_5661_((Component)ModTexts.Messages.errorNoTargetFound(ModTexts.BLOCK), false);
        }
    }

    public static void processEntityEditorRequest(ServerPlayer player, EditorType editorType, int entityId) {
        if (ServerEditorLogic.checkPermission(player)) {
            return;
        }
        ServerLevel level = player.m_183503_();
        Entity entity = level.m_6815_(entityId);
        if (entity != null) {
            CompoundTag tag = entity.m_20240_(new CompoundTag());
            ServerNetworkEmitter.sendEntityEditorResponse(player, editorType, entityId, tag);
        } else {
            player.m_5661_((Component)ModTexts.Messages.errorNoTargetFound(ModTexts.ENTITY), false);
        }
    }

    private static boolean checkPermission(ServerPlayer player) {
        if (!player.m_20310_(CommonConfiguration.INSTANCE.getPermissionLevel()) || CommonConfiguration.INSTANCE.isCreativeOnly() && !player.m_7500_()) {
            LOGGER.warn("Player {} does not have the permission to use the editor", (Object)player.m_36316_().getName());
            player.m_5661_((Component)ModTexts.Messages.NO_PERMISSION, false);
            return true;
        }
        return false;
    }
}

