/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.base.server;

import com.github.franckyi.ibeeditor.base.common.packet.BlockEditorRequestPacket;
import com.github.franckyi.ibeeditor.base.common.packet.BlockInventoryItemEditorRequestPacket;
import com.github.franckyi.ibeeditor.base.common.packet.BlockInventoryItemUpdatePacket;
import com.github.franckyi.ibeeditor.base.common.packet.BlockUpdatePacket;
import com.github.franckyi.ibeeditor.base.common.packet.ClientNotificationPacket;
import com.github.franckyi.ibeeditor.base.common.packet.EntityEditorRequestPacket;
import com.github.franckyi.ibeeditor.base.common.packet.EntityUpdatePacket;
import com.github.franckyi.ibeeditor.base.common.packet.MainHandItemEditorRequestPacket;
import com.github.franckyi.ibeeditor.base.common.packet.PlayerInventoryItemEditorRequestPacket;
import com.github.franckyi.ibeeditor.base.common.packet.PlayerInventoryItemUpdatePacket;
import com.github.franckyi.ibeeditor.base.common.packet.PlayerMainHandItemUpdatePacket;
import com.github.franckyi.ibeeditor.base.server.ServerContext;
import com.github.franckyi.ibeeditor.base.server.ServerEditorLogic;
import net.minecraft.server.level.ServerPlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ServerNetworkReceiver {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void onClientNotification(ClientNotificationPacket packet, ServerPlayer player) {
        ServerNetworkReceiver.log("ibeeditor:network/client_notification", player);
        if (packet.getValue()) {
            ServerContext.addModdedClient(player);
        }
    }

    public static void onPlayerMainHandItemUpdate(PlayerMainHandItemUpdatePacket packet, ServerPlayer player) {
        ServerNetworkReceiver.log("ibeeditor:network/player_main_hand_item_update", player);
        ServerEditorLogic.updatePlayerMainHandItem(player, packet.getItem());
    }

    public static void onPlayerInventoryItemUpdate(PlayerInventoryItemUpdatePacket packet, ServerPlayer player) {
        ServerNetworkReceiver.log("ibeeditor:network/player_inventory_item_update", player);
        ServerEditorLogic.updatePlayerInventoryItem(player, packet.getItem(), packet.getSlotId());
    }

    public static void onBlockInventoryItemUpdate(BlockInventoryItemUpdatePacket packet, ServerPlayer player) {
        ServerNetworkReceiver.log("ibeeditor:network/block_inventory_item_update", player);
        ServerEditorLogic.updateBlockInventoryItem(player, packet.getItem(), packet.getSlotId(), packet.getPos());
    }

    public static void onBlockUpdate(BlockUpdatePacket packet, ServerPlayer player) {
        ServerNetworkReceiver.log("ibeeditor:network/block_update", player);
        ServerEditorLogic.updateBlock(player, packet.getPos(), packet.getState(), packet.getTag());
    }

    public static void onEntityUpdate(EntityUpdatePacket packet, ServerPlayer player) {
        ServerNetworkReceiver.log("ibeeditor:network/entity_update", player);
        ServerEditorLogic.updateEntity(player, packet.getEntity(), packet.getEntityId());
    }

    public static void onMainHandItemEditorRequest(MainHandItemEditorRequestPacket packet, ServerPlayer player) {
        ServerNetworkReceiver.log("ibeeditor:network/main_hand_item_editor_request", player);
        ServerEditorLogic.processMainHandItemEditorRequest(player, packet.getEditorType());
    }

    public static void onPlayerInventoryItemEditorRequest(PlayerInventoryItemEditorRequestPacket packet, ServerPlayer player) {
        ServerNetworkReceiver.log("ibeeditor:network/player_inventory_item_editor_request", player);
        ServerEditorLogic.processPlayerInventoryItemEditorRequest(player, packet.getEditorType(), packet.getSlotIndex(), packet.isCreativeInventoryScreen());
    }

    public static void onBlockInventoryItemEditorRequest(BlockInventoryItemEditorRequestPacket packet, ServerPlayer player) {
        ServerNetworkReceiver.log("ibeeditor:network/block_inventory_item_editor_request", player);
        ServerEditorLogic.processBlockInventoryItemEditorRequest(player, packet.getEditorType(), packet.getSlotIndex(), packet.getPos());
    }

    public static void onBlockEditorRequest(BlockEditorRequestPacket packet, ServerPlayer player) {
        ServerNetworkReceiver.log("ibeeditor:network/block_editor_request", player);
        ServerEditorLogic.processBlockEditorRequest(player, packet.getEditorType(), packet.getPos());
    }

    public static void onEntityEditorRequest(EntityEditorRequestPacket packet, ServerPlayer player) {
        ServerNetworkReceiver.log("ibeeditor:network/entity_editor_request", player);
        ServerEditorLogic.processEntityEditorRequest(player, packet.getEditorType(), packet.getEntityId());
    }

    private static void log(String id, ServerPlayer player) {
        LOGGER.debug("Receiving packet {} from player {}", (Object)id, (Object)player.m_36316_().getName());
    }
}

