/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.forge;

import com.github.franckyi.ibeeditor.base.common.NetworkManager;
import com.github.franckyi.ibeeditor.base.common.Packet;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class PlatformUtilImpl {
    private static final String VERSION = "2";
    private static final SimpleChannel channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("ibeeditor:network"), () -> "2", "2"::equals, "2"::equals);

    public static Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }

    public static void sendToServer(String id, Packet packet) {
        channel.sendToServer((Object)packet);
    }

    public static void sendToClient(String id, ServerPlayer player, Packet packet) {
        channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }

    public static <P extends Packet> void registerServerHandler(String id, int id1, Class<P> msgClass, NetworkManager.PacketReader<P> reader, NetworkManager.ServerPacketHandler<P> handler) {
        PlatformUtilImpl.registerHandler(id1, msgClass, reader, (msg, ctx) -> handler.accept(msg, ((NetworkEvent.Context)ctx.get()).getSender()));
    }

    public static <P extends Packet> void registerClientHandler(String id, int id1, Class<P> msgClass, NetworkManager.PacketReader<P> reader, NetworkManager.ClientPacketHandler<P> handler) {
        PlatformUtilImpl.registerHandler(id1, msgClass, reader, (msg, ctx) -> handler.accept(msg));
    }

    private static <P extends Packet> void registerHandler(int id, Class<P> msgClass, NetworkManager.PacketReader<P> reader, BiConsumer<P, Supplier<NetworkEvent.Context>> handler) {
        channel.messageBuilder(msgClass, id).decoder(buffer -> {
            try {
                return (Packet)reader.read((FriendlyByteBuf)buffer);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).encoder((p, buffer) -> {
            try {
                p.write((FriendlyByteBuf)buffer);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).consumer((msg, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> PlatformUtilImpl.lambda$registerHandler$6(handler, msg, (Supplier)ctx));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        }).add();
    }

    private static /* synthetic */ void lambda$registerHandler$6(BiConsumer handler, Packet msg, Supplier ctx) {
        handler.accept(msg, ctx);
    }
}

