/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.databindings.api;

import com.github.franckyi.databindings.api.DataBindings;
import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.franckyi.databindings.api.ObservableValue;
import java.util.function.Supplier;

public interface ObservableObjectValue<T>
extends ObservableValue<T> {
    public static <T> ObservableObjectValue<T> unmodifiable(final T value) {
        return new Unmodifiable<T>(){

            @Override
            public T get() {
                return value;
            }
        };
    }

    public static <T> ObservableObjectValue<T> readOnly(ObjectProperty<T> property) {
        return DataBindings.getPropertyFactory().createReadOnlyProperty(property);
    }

    public static <T> ObservableObjectValue<T> observe(Supplier<T> valueSupplier, ObservableValue<?> ... triggers) {
        return DataBindings.getMappingFactory().createMapping(valueSupplier, triggers);
    }

    default public T getValue() {
        return this.get();
    }

    default public boolean hasValue() {
        return this.get() != null;
    }

    public static abstract class Unmodifiable<T>
    extends ObservableValue.Unmodifiable<T>
    implements ObservableObjectValue<T> {
    }
}

